@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin

import com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs.builder
import com.pulumi.azurenative.securityandcompliance.kotlin.enums.Kind
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.ServicesPropertiesArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.ServicesPropertiesArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.ServicesResourceIdentityArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.ServicesResourceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of the service.
 * Azure REST API version: 2021-03-08. Prior API version in Azure Native 1.x: 2021-03-08.
 * ## Example Usage
 * ### Create or Update a service with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkServicesForM365SecurityCenter = new AzureNative.SecurityAndCompliance.PrivateLinkServicesForM365SecurityCenter("privateLinkServicesForM365SecurityCenter", new()
 *     {
 *         Identity = new AzureNative.SecurityAndCompliance.Inputs.ServicesResourceIdentityArgs
 *         {
 *             Type = AzureNative.SecurityAndCompliance.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.SecurityAndCompliance.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.SecurityAndCompliance.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *                 new AzureNative.SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *                 },
 *             },
 *             AuthenticationConfiguration = new AzureNative.SecurityAndCompliance.Inputs.ServiceAuthenticationConfigurationInfoArgs
 *             {
 *                 Audience = "https://azurehealthcareapis.com",
 *                 Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *                 SmartProxyEnabled = true,
 *             },
 *             CorsConfiguration = new AzureNative.SecurityAndCompliance.Inputs.ServiceCorsConfigurationInfoArgs
 *             {
 *                 AllowCredentials = false,
 *                 Headers = new[]
 *                 {
 *                     "*",
 *                 },
 *                 MaxAge = 1440,
 *                 Methods = new[]
 *                 {
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT",
 *                 },
 *                 Origins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             CosmosDbConfiguration = new AzureNative.SecurityAndCompliance.Inputs.ServiceCosmosDbConfigurationInfoArgs
 *             {
 *                 KeyVaultKeyUri = "https://my-vault.vault.azure.net/keys/my-key",
 *                 OfferThroughput = 1000,
 *             },
 *             ExportConfiguration = new AzureNative.SecurityAndCompliance.Inputs.ServiceExportConfigurationInfoArgs
 *             {
 *                 StorageAccountName = "existingStorageAccount",
 *             },
 *             PrivateEndpointConnections = new() { },
 *             PublicNetworkAccess = AzureNative.SecurityAndCompliance.PublicNetworkAccess.Disabled,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityandcompliance.NewPrivateLinkServicesForM365SecurityCenter(ctx, "privateLinkServicesForM365SecurityCenter", &securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs{
 * 			Identity: &securityandcompliance.ServicesResourceIdentityArgs{
 * 				Type: pulumi.String(securityandcompliance.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Kind:     securityandcompliance.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &securityandcompliance.ServicesPropertiesArgs{
 * 				AccessPolicies: securityandcompliance.ServiceAccessPolicyEntryArray{
 * 					&securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 					&securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 					},
 * 				},
 * 				AuthenticationConfiguration: &securityandcompliance.ServiceAuthenticationConfigurationInfoArgs{
 * 					Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 					Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 					SmartProxyEnabled: pulumi.Bool(true),
 * 				},
 * 				CorsConfiguration: &securityandcompliance.ServiceCorsConfigurationInfoArgs{
 * 					AllowCredentials: pulumi.Bool(false),
 * 					Headers: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					MaxAge: pulumi.Float64(1440),
 * 					Methods: pulumi.StringArray{
 * 						pulumi.String("DELETE"),
 * 						pulumi.String("GET"),
 * 						pulumi.String("OPTIONS"),
 * 						pulumi.String("PATCH"),
 * 						pulumi.String("POST"),
 * 						pulumi.String("PUT"),
 * 					},
 * 					Origins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				CosmosDbConfiguration: &securityandcompliance.ServiceCosmosDbConfigurationInfoArgs{
 * 					KeyVaultKeyUri:  pulumi.String("https://my-vault.vault.azure.net/keys/my-key"),
 * 					OfferThroughput: pulumi.Float64(1000),
 * 				},
 * 				ExportConfiguration: &securityandcompliance.ServiceExportConfigurationInfoArgs{
 * 					StorageAccountName: pulumi.String("existingStorageAccount"),
 * 				},
 * 				PrivateEndpointConnections: securityandcompliance.PrivateEndpointConnectionArray{},
 * 				PublicNetworkAccess:        pulumi.String(securityandcompliance.PublicNetworkAccessDisabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenter;
 * import com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs;
 * import com.pulumi.azurenative.securityandcompliance.inputs.ServicesResourceIdentityArgs;
 * import com.pulumi.azurenative.securityandcompliance.inputs.ServicesPropertiesArgs;
 * import com.pulumi.azurenative.securityandcompliance.inputs.ServiceAuthenticationConfigurationInfoArgs;
 * import com.pulumi.azurenative.securityandcompliance.inputs.ServiceCorsConfigurationInfoArgs;
 * import com.pulumi.azurenative.securityandcompliance.inputs.ServiceCosmosDbConfigurationInfoArgs;
 * import com.pulumi.azurenative.securityandcompliance.inputs.ServiceExportConfigurationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkServicesForM365SecurityCenter = new PrivateLinkServicesForM365SecurityCenter("privateLinkServicesForM365SecurityCenter", PrivateLinkServicesForM365SecurityCenterArgs.builder()
 *             .identity(ServicesResourceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                         .build(),
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("5b307da8-43d4-492b-8b66-b0294ade872f")
 *                         .build())
 *                 .authenticationConfiguration(ServiceAuthenticationConfigurationInfoArgs.builder()
 *                     .audience("https://azurehealthcareapis.com")
 *                     .authority("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc")
 *                     .smartProxyEnabled(true)
 *                     .build())
 *                 .corsConfiguration(ServiceCorsConfigurationInfoArgs.builder()
 *                     .allowCredentials(false)
 *                     .headers("*")
 *                     .maxAge(1440)
 *                     .methods(
 *                         "DELETE",
 *                         "GET",
 *                         "OPTIONS",
 *                         "PATCH",
 *                         "POST",
 *                         "PUT")
 *                     .origins("*")
 *                     .build())
 *                 .cosmosDbConfiguration(ServiceCosmosDbConfigurationInfoArgs.builder()
 *                     .keyVaultKeyUri("https://my-vault.vault.azure.net/keys/my-key")
 *                     .offerThroughput(1000)
 *                     .build())
 *                 .exportConfiguration(ServiceExportConfigurationInfoArgs.builder()
 *                     .storageAccountName("existingStorageAccount")
 *                     .build())
 *                 .privateEndpointConnections()
 *                 .publicNetworkAccess("Disabled")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a service with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkServicesForM365SecurityCenter = new AzureNative.SecurityAndCompliance.PrivateLinkServicesForM365SecurityCenter("privateLinkServicesForM365SecurityCenter", new()
 *     {
 *         Kind = AzureNative.SecurityAndCompliance.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.SecurityAndCompliance.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service2",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityandcompliance.NewPrivateLinkServicesForM365SecurityCenter(ctx, "privateLinkServicesForM365SecurityCenter", &securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs{
 * 			Kind:     securityandcompliance.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &securityandcompliance.ServicesPropertiesArgs{
 * 				AccessPolicies: securityandcompliance.ServiceAccessPolicyEntryArray{
 * 					&securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service2"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenter;
 * import com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs;
 * import com.pulumi.azurenative.securityandcompliance.inputs.ServicesPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkServicesForM365SecurityCenter = new PrivateLinkServicesForM365SecurityCenter("privateLinkServicesForM365SecurityCenter", PrivateLinkServicesForM365SecurityCenterArgs.builder()
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(ServiceAccessPolicyEntryArgs.builder()
 *                     .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service2")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityandcompliance:PrivateLinkServicesForM365SecurityCenter service2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/{resourceName}
 * ```
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property kind The kind of the service.
 * @property location The resource location.
 * @property properties The common properties of a service.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 * @property tags The resource tags.
 */
public data class PrivateLinkServicesForM365SecurityCenterArgs(
    public val identity: Output<ServicesResourceIdentityArgs>? = null,
    public val kind: Output<Kind>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ServicesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs =
        com.pulumi.azurenative.securityandcompliance.PrivateLinkServicesForM365SecurityCenterArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServicesForM365SecurityCenterArgs].
 */
@PulumiTagMarker
public class PrivateLinkServicesForM365SecurityCenterArgsBuilder internal constructor() {
    private var identity: Output<ServicesResourceIdentityArgs>? = null

    private var kind: Output<Kind>? = null

    private var location: Output<String>? = null

    private var properties: Output<ServicesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("msjybkylcyfwqlgj")
    public suspend fun identity(`value`: Output<ServicesResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("mmsracyxqbxrdaol")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("kpthxvllxmabpygg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The common properties of a service.
     */
    @JvmName("ohhbrdfpxyvlpirh")
    public suspend fun properties(`value`: Output<ServicesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("ujesdxbkqrslbogv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("bydsfdueugttebuh")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("nvfipbbkunfgmmnx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("gyfycgkujgyxbjae")
    public suspend fun identity(`value`: ServicesResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("uawenvwfagvtlfiw")
    public suspend fun identity(argument: suspend ServicesResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ServicesResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("jihgjvahwnrqpewn")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("ktgwkmloqmckumgd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The common properties of a service.
     */
    @JvmName("mphkamgeckvbvwsr")
    public suspend fun properties(`value`: ServicesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The common properties of a service.
     */
    @JvmName("vmrklvrnwlmcciot")
    public suspend fun properties(argument: suspend ServicesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServicesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("xfrfpylrquphejvv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("kmewcyeyibffgrua")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("vfqaneqxohmodbvu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("lgecpbslrnilxibo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateLinkServicesForM365SecurityCenterArgs =
        PrivateLinkServicesForM365SecurityCenterArgs(
            identity = identity,
            kind = kind,
            location = location,
            properties = properties,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            tags = tags,
        )
}
