@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.securityandcompliance.inputs.ServicesPropertiesArgs.builder
import com.pulumi.azurenative.securityandcompliance.kotlin.enums.PublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a service instance.
 * @property accessPolicies The access policies of the service instance.
 * @property authenticationConfiguration The authentication configuration for the service instance.
 * @property corsConfiguration The settings for the CORS configuration of the service instance.
 * @property cosmosDbConfiguration The settings for the Cosmos DB database backing the service.
 * @property exportConfiguration The settings for the export operation of the service instance.
 * @property privateEndpointConnections The list of private endpoint connections that are set up for this resource.
 * @property publicNetworkAccess Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 */
public data class ServicesPropertiesArgs(
    public val accessPolicies: Output<List<ServiceAccessPolicyEntryArgs>>? = null,
    public val authenticationConfiguration: Output<ServiceAuthenticationConfigurationInfoArgs>? =
        null,
    public val corsConfiguration: Output<ServiceCorsConfigurationInfoArgs>? = null,
    public val cosmosDbConfiguration: Output<ServiceCosmosDbConfigurationInfoArgs>? = null,
    public val exportConfiguration: Output<ServiceExportConfigurationInfoArgs>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.inputs.ServicesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityandcompliance.inputs.ServicesPropertiesArgs =
        com.pulumi.azurenative.securityandcompliance.inputs.ServicesPropertiesArgs.builder()
            .accessPolicies(
                accessPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .authenticationConfiguration(
                authenticationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .corsConfiguration(corsConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cosmosDbConfiguration(
                cosmosDbConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .exportConfiguration(
                exportConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ServicesPropertiesArgs].
 */
@PulumiTagMarker
public class ServicesPropertiesArgsBuilder internal constructor() {
    private var accessPolicies: Output<List<ServiceAccessPolicyEntryArgs>>? = null

    private var authenticationConfiguration: Output<ServiceAuthenticationConfigurationInfoArgs>? =
        null

    private var corsConfiguration: Output<ServiceCorsConfigurationInfoArgs>? = null

    private var cosmosDbConfiguration: Output<ServiceCosmosDbConfigurationInfoArgs>? = null

    private var exportConfiguration: Output<ServiceExportConfigurationInfoArgs>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    /**
     * @param value The access policies of the service instance.
     */
    @JvmName("vojiyqoxffiwaetf")
    public suspend fun accessPolicies(`value`: Output<List<ServiceAccessPolicyEntryArgs>>) {
        this.accessPolicies = value
    }

    @JvmName("lphwohrmfqnymarg")
    public suspend fun accessPolicies(vararg values: Output<ServiceAccessPolicyEntryArgs>) {
        this.accessPolicies = Output.all(values.asList())
    }

    /**
     * @param values The access policies of the service instance.
     */
    @JvmName("qmxsbwwwqossjayh")
    public suspend fun accessPolicies(values: List<Output<ServiceAccessPolicyEntryArgs>>) {
        this.accessPolicies = Output.all(values)
    }

    /**
     * @param value The authentication configuration for the service instance.
     */
    @JvmName("gmmrgpqmulvlutjd")
    public suspend
    fun authenticationConfiguration(`value`: Output<ServiceAuthenticationConfigurationInfoArgs>) {
        this.authenticationConfiguration = value
    }

    /**
     * @param value The settings for the CORS configuration of the service instance.
     */
    @JvmName("tyhjrjpnnadoqmoa")
    public suspend fun corsConfiguration(`value`: Output<ServiceCorsConfigurationInfoArgs>) {
        this.corsConfiguration = value
    }

    /**
     * @param value The settings for the Cosmos DB database backing the service.
     */
    @JvmName("cmyrovlqtkqmbarg")
    public suspend fun cosmosDbConfiguration(`value`: Output<ServiceCosmosDbConfigurationInfoArgs>) {
        this.cosmosDbConfiguration = value
    }

    /**
     * @param value The settings for the export operation of the service instance.
     */
    @JvmName("yeqrurmuxfeuffut")
    public suspend fun exportConfiguration(`value`: Output<ServiceExportConfigurationInfoArgs>) {
        this.exportConfiguration = value
    }

    /**
     * @param value The list of private endpoint connections that are set up for this resource.
     */
    @JvmName("ksrxhlmidipjqqna")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("eqoassprxfkcxusk")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values The list of private endpoint connections that are set up for this resource.
     */
    @JvmName("hyfqmxktbfotylct")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("crrdnntafklyscml")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The access policies of the service instance.
     */
    @JvmName("mmiikjmdkfdneguv")
    public suspend fun accessPolicies(`value`: List<ServiceAccessPolicyEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param argument The access policies of the service instance.
     */
    @JvmName("becwtlbssvcsaqga")
    public suspend
    fun accessPolicies(argument: List<suspend ServiceAccessPolicyEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceAccessPolicyEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument The access policies of the service instance.
     */
    @JvmName("cdivstpwhbwjsvyo")
    public suspend fun accessPolicies(
        vararg
        argument: suspend ServiceAccessPolicyEntryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceAccessPolicyEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument The access policies of the service instance.
     */
    @JvmName("pjafqwmejxqqxrbf")
    public suspend
    fun accessPolicies(argument: suspend ServiceAccessPolicyEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceAccessPolicyEntryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param values The access policies of the service instance.
     */
    @JvmName("rkmdehnjtwgddbuo")
    public suspend fun accessPolicies(vararg values: ServiceAccessPolicyEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value The authentication configuration for the service instance.
     */
    @JvmName("pdthpgjkpbahuhwp")
    public suspend
    fun authenticationConfiguration(`value`: ServiceAuthenticationConfigurationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationConfiguration = mapped
    }

    /**
     * @param argument The authentication configuration for the service instance.
     */
    @JvmName("dfohmyqglwkhqjcj")
    public suspend
    fun authenticationConfiguration(argument: suspend ServiceAuthenticationConfigurationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceAuthenticationConfigurationInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticationConfiguration = mapped
    }

    /**
     * @param value The settings for the CORS configuration of the service instance.
     */
    @JvmName("gyqcrceoqbmfxrss")
    public suspend fun corsConfiguration(`value`: ServiceCorsConfigurationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsConfiguration = mapped
    }

    /**
     * @param argument The settings for the CORS configuration of the service instance.
     */
    @JvmName("uahutboevnygrrjb")
    public suspend
    fun corsConfiguration(argument: suspend ServiceCorsConfigurationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceCorsConfigurationInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsConfiguration = mapped
    }

    /**
     * @param value The settings for the Cosmos DB database backing the service.
     */
    @JvmName("pruphvromtojaebr")
    public suspend fun cosmosDbConfiguration(`value`: ServiceCosmosDbConfigurationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cosmosDbConfiguration = mapped
    }

    /**
     * @param argument The settings for the Cosmos DB database backing the service.
     */
    @JvmName("iqouqpmdfmkvpojt")
    public suspend
    fun cosmosDbConfiguration(argument: suspend ServiceCosmosDbConfigurationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceCosmosDbConfigurationInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cosmosDbConfiguration = mapped
    }

    /**
     * @param value The settings for the export operation of the service instance.
     */
    @JvmName("xifgugqppshndphg")
    public suspend fun exportConfiguration(`value`: ServiceExportConfigurationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportConfiguration = mapped
    }

    /**
     * @param argument The settings for the export operation of the service instance.
     */
    @JvmName("dccibdjqtnuxrctu")
    public suspend
    fun exportConfiguration(argument: suspend ServiceExportConfigurationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceExportConfigurationInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportConfiguration = mapped
    }

    /**
     * @param value The list of private endpoint connections that are set up for this resource.
     */
    @JvmName("dceifcxwwoyntpho")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument The list of private endpoint connections that are set up for this resource.
     */
    @JvmName("wykpglewekjksnss")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument The list of private endpoint connections that are set up for this resource.
     */
    @JvmName("dwvvnkhjaimshimf")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument The list of private endpoint connections that are set up for this resource.
     */
    @JvmName("ceiepxgwqpeivevu")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values The list of private endpoint connections that are set up for this resource.
     */
    @JvmName("karxmvmoesxrevmf")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("katvqrfqxupfqyvo")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("rnilqewsvskxgjnn")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("vuytfuwcevaventg")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    internal fun build(): ServicesPropertiesArgs = ServicesPropertiesArgs(
        accessPolicies = accessPolicies,
        authenticationConfiguration = authenticationConfiguration,
        corsConfiguration = corsConfiguration,
        cosmosDbConfiguration = cosmosDbConfiguration,
        exportConfiguration = exportConfiguration,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
    )
}
