@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin

import com.pulumi.azurenative.securitydevops.kotlin.outputs.AzureDevOpsConnectorPropertiesResponse
import com.pulumi.azurenative.securitydevops.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.securitydevops.kotlin.outputs.AzureDevOpsConnectorPropertiesResponse.Companion.toKotlin as azureDevOpsConnectorPropertiesResponseToKotlin
import com.pulumi.azurenative.securitydevops.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AzureDevOpsConnector].
 */
@PulumiTagMarker
public class AzureDevOpsConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureDevOpsConnectorArgs = AzureDevOpsConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureDevOpsConnectorArgsBuilder.() -> Unit) {
        val builder = AzureDevOpsConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AzureDevOpsConnector {
        val builtJavaResource =
            com.pulumi.azurenative.securitydevops.AzureDevOpsConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AzureDevOpsConnector(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### AzureDevOpsConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureDevOpsConnector = new AzureNative.SecurityDevOps.AzureDevOpsConnector("azureDevOpsConnector", new()
 *     {
 *         AzureDevOpsConnectorName = "testconnector",
 *         Location = "West US",
 *         Properties = new AzureNative.SecurityDevOps.Inputs.AzureDevOpsConnectorPropertiesArgs
 *         {
 *             Authorization = new AzureNative.SecurityDevOps.Inputs.AuthorizationInfoArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             Orgs = new[]
 *             {
 *                 new AzureNative.SecurityDevOps.Inputs.AzureDevOpsOrgMetadataArgs
 *                 {
 *                     Name = "testOrg",
 *                     Projects = new[]
 *                     {
 *                         new AzureNative.SecurityDevOps.Inputs.AzureDevOpsProjectMetadataArgs
 *                         {
 *                             Name = "testProject",
 *                             Repos = new[]
 *                             {
 *                                 "testRepo",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "westusrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securitydevops/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitydevops.NewAzureDevOpsConnector(ctx, "azureDevOpsConnector", &securitydevops.AzureDevOpsConnectorArgs{
 * 			AzureDevOpsConnectorName: pulumi.String("testconnector"),
 * 			Location:                 pulumi.String("West US"),
 * 			Properties: &securitydevops.AzureDevOpsConnectorPropertiesArgs{
 * 				Authorization: &securitydevops.AuthorizationInfoArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				Orgs: securitydevops.AzureDevOpsOrgMetadataArray{
 * 					&securitydevops.AzureDevOpsOrgMetadataArgs{
 * 						Name: pulumi.String("testOrg"),
 * 						Projects: securitydevops.AzureDevOpsProjectMetadataArray{
 * 							&securitydevops.AzureDevOpsProjectMetadataArgs{
 * 								Name: pulumi.String("testProject"),
 * 								Repos: pulumi.StringArray{
 * 									pulumi.String("testRepo"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("westusrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securitydevops.AzureDevOpsConnector;
 * import com.pulumi.azurenative.securitydevops.AzureDevOpsConnectorArgs;
 * import com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsConnectorPropertiesArgs;
 * import com.pulumi.azurenative.securitydevops.inputs.AuthorizationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureDevOpsConnector = new AzureDevOpsConnector("azureDevOpsConnector", AzureDevOpsConnectorArgs.builder()
 *             .azureDevOpsConnectorName("testconnector")
 *             .location("West US")
 *             .properties(AzureDevOpsConnectorPropertiesArgs.builder()
 *                 .authorization(AuthorizationInfoArgs.builder()
 *                     .code("00000000000000000000")
 *                     .build())
 *                 .orgs(AzureDevOpsOrgMetadataArgs.builder()
 *                     .name("testOrg")
 *                     .projects(AzureDevOpsProjectMetadataArgs.builder()
 *                         .name("testProject")
 *                         .repos("testRepo")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("westusrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securitydevops:AzureDevOpsConnector testconnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}
 * ```
 */
public class AzureDevOpsConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.securitydevops.AzureDevOpsConnector,
) : KotlinCustomResource(javaResource, AzureDevOpsConnectorMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<AzureDevOpsConnectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                azureDevOpsConnectorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AzureDevOpsConnectorMapper : ResourceMapper<AzureDevOpsConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securitydevops.AzureDevOpsConnector::class == javaResource::class

    override fun map(javaResource: Resource): AzureDevOpsConnector = AzureDevOpsConnector(
        javaResource
            as com.pulumi.azurenative.securitydevops.AzureDevOpsConnector,
    )
}

/**
 * @see [AzureDevOpsConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureDevOpsConnector].
 */
public suspend fun azureDevOpsConnector(
    name: String,
    block: suspend AzureDevOpsConnectorResourceBuilder.() -> Unit,
): AzureDevOpsConnector {
    val builder = AzureDevOpsConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureDevOpsConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureDevOpsConnector(name: String): AzureDevOpsConnector {
    val builder = AzureDevOpsConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
