@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.inputs

import com.pulumi.azurenative.securitydevops.inputs.GitHubConnectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
 * @property code Gets or sets one-time OAuth code to exchange for refresh and access tokens.
 * Only used during PUT operations. The secret is cleared during GET.
 * In general, RPaaS does not return any property marked as a secret.
 */
public data class GitHubConnectorPropertiesArgs(
    public val code: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.inputs.GitHubConnectorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.securitydevops.inputs.GitHubConnectorPropertiesArgs =
        com.pulumi.azurenative.securitydevops.inputs.GitHubConnectorPropertiesArgs.builder()
            .code(code?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubConnectorPropertiesArgs].
 */
@PulumiTagMarker
public class GitHubConnectorPropertiesArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    /**
     * @param value Gets or sets one-time OAuth code to exchange for refresh and access tokens.
     * Only used during PUT operations. The secret is cleared during GET.
     * In general, RPaaS does not return any property marked as a secret.
     */
    @JvmName("mnkaoevbpfeqdlml")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Gets or sets one-time OAuth code to exchange for refresh and access tokens.
     * Only used during PUT operations. The secret is cleared during GET.
     * In general, RPaaS does not return any property marked as a secret.
     */
    @JvmName("dwpjiwvmxonracsq")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    internal fun build(): GitHubConnectorPropertiesArgs = GitHubConnectorPropertiesArgs(
        code = code,
    )
}
