@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property code Gets or sets one-time OAuth code to exchange for refresh and access tokens.
 * Only used during PUT operations. The secret is cleared during GET.
 * In general, RPaaS does not return any property marked as a secret.
 */
public data class AuthorizationInfoResponse(
    public val code: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securitydevops.outputs.AuthorizationInfoResponse):
            AuthorizationInfoResponse = AuthorizationInfoResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
        )
    }
}
