@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleModifyPropertiesActionResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleRunPlaybookActionResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleTriggeringLogicResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleTriggeringLogicResponse.Companion.toKotlin as automationRuleTriggeringLogicResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin as clientInfoResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AutomationRule].
 */
@PulumiTagMarker
public class AutomationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutomationRuleArgs = AutomationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutomationRuleArgsBuilder.() -> Unit) {
        val builder = AutomationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutomationRule {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.AutomationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AutomationRule(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2019-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### AutomationRules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automationRule = new AzureNative.SecurityInsights.AutomationRule("automationRule", new()
 *     {
 *         AutomationRuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAutomationRule(ctx, "automationRule", &securityinsights.AutomationRuleArgs{
 * 			AutomationRuleId:  pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AutomationRule;
 * import com.pulumi.azurenative.securityinsights.AutomationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automationRule = new AutomationRule("automationRule", AutomationRuleArgs.builder()
 *             .automationRuleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:AutomationRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/automationRules/{automationRuleId}
 * ```
 */
public class AutomationRule internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.AutomationRule,
) : KotlinCustomResource(javaResource, AutomationRuleMapper) {
    /**
     * The actions to execute when the automation rule is triggered.
     */
    public val actions:
        Output<List<Either<AutomationRuleModifyPropertiesActionResponse, AutomationRuleRunPlaybookActionResponse>>>
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleModifyPropertiesActionResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleRunPlaybookActionResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            })
        })

    /**
     * Information on the client (user or application) that made some action
     */
    public val createdBy: Output<ClientInfoResponse>
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.let({ args0 ->
                clientInfoResponseToKotlin(args0)
            })
        })

    /**
     * The time the automation rule was created.
     */
    public val createdTimeUtc: Output<String>
        get() = javaResource.createdTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The display name of the automation rule.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Information on the client (user or application) that made some action
     */
    public val lastModifiedBy: Output<ClientInfoResponse>
        get() = javaResource.lastModifiedBy().applyValue({ args0 ->
            args0.let({ args0 ->
                clientInfoResponseToKotlin(args0)
            })
        })

    /**
     * The last time the automation rule was updated.
     */
    public val lastModifiedTimeUtc: Output<String>
        get() = javaResource.lastModifiedTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The order of execution of the automation rule.
     */
    public val order: Output<Int>
        get() = javaResource.order().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Describes automation rule triggering logic.
     */
    public val triggeringLogic: Output<AutomationRuleTriggeringLogicResponse>
        get() = javaResource.triggeringLogic().applyValue({ args0 ->
            args0.let({ args0 ->
                automationRuleTriggeringLogicResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AutomationRuleMapper : ResourceMapper<AutomationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.AutomationRule::class == javaResource::class

    override fun map(javaResource: Resource): AutomationRule = AutomationRule(
        javaResource as
            com.pulumi.azurenative.securityinsights.AutomationRule,
    )
}

/**
 * @see [AutomationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutomationRule].
 */
public suspend fun automationRule(
    name: String,
    block: suspend AutomationRuleResourceBuilder.() -> Unit,
): AutomationRule {
    val builder = AutomationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutomationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun automationRule(name: String): AutomationRule {
    val builder = AutomationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
