@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.AutomationRuleArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AutomationRuleModifyPropertiesActionArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AutomationRuleRunPlaybookActionArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AutomationRuleTriggeringLogicArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AutomationRuleTriggeringLogicArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2019-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### AutomationRules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automationRule = new AzureNative.SecurityInsights.AutomationRule("automationRule", new()
 *     {
 *         AutomationRuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAutomationRule(ctx, "automationRule", &securityinsights.AutomationRuleArgs{
 * 			AutomationRuleId:  pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AutomationRule;
 * import com.pulumi.azurenative.securityinsights.AutomationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automationRule = new AutomationRule("automationRule", AutomationRuleArgs.builder()
 *             .automationRuleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:AutomationRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/automationRules/{automationRuleId}
 * ```
 * @property actions The actions to execute when the automation rule is triggered.
 * @property automationRuleId Automation rule ID
 * @property displayName The display name of the automation rule.
 * @property order The order of execution of the automation rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property triggeringLogic Describes automation rule triggering logic.
 * @property workspaceName The name of the workspace.
 */
public data class AutomationRuleArgs(
    public val actions:
    Output<List<Either<AutomationRuleModifyPropertiesActionArgs, AutomationRuleRunPlaybookActionArgs>>>? =
        null,
    public val automationRuleId: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val order: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val triggeringLogic: Output<AutomationRuleTriggeringLogicArgs>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.AutomationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.AutomationRuleArgs =
        com.pulumi.azurenative.securityinsights.AutomationRuleArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .automationRuleId(automationRuleId?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .order(order?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .triggeringLogic(triggeringLogic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleArgs].
 */
@PulumiTagMarker
public class AutomationRuleArgsBuilder internal constructor() {
    private var actions:
        Output<List<Either<AutomationRuleModifyPropertiesActionArgs, AutomationRuleRunPlaybookActionArgs>>>? =
        null

    private var automationRuleId: Output<String>? = null

    private var displayName: Output<String>? = null

    private var order: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var triggeringLogic: Output<AutomationRuleTriggeringLogicArgs>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The actions to execute when the automation rule is triggered.
     */
    @JvmName("edhwyshyyembyotk")
    public suspend
    fun actions(`value`: Output<List<Either<AutomationRuleModifyPropertiesActionArgs, AutomationRuleRunPlaybookActionArgs>>>) {
        this.actions = value
    }

    @JvmName("deycmxiwvqvhglds")
    public suspend fun actions(
        vararg
        values: Output<Either<AutomationRuleModifyPropertiesActionArgs, AutomationRuleRunPlaybookActionArgs>>,
    ) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values The actions to execute when the automation rule is triggered.
     */
    @JvmName("mvxeeewviqokjqul")
    public suspend
    fun actions(values: List<Output<Either<AutomationRuleModifyPropertiesActionArgs, AutomationRuleRunPlaybookActionArgs>>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Automation rule ID
     */
    @JvmName("ooxaphovjwhkktse")
    public suspend fun automationRuleId(`value`: Output<String>) {
        this.automationRuleId = value
    }

    /**
     * @param value The display name of the automation rule.
     */
    @JvmName("bccpwugpjonqbqkw")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The order of execution of the automation rule.
     */
    @JvmName("dwvwsvitjjgtslxh")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("suighkkxfrpydqom")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Describes automation rule triggering logic.
     */
    @JvmName("qkxkrpdfixblyxrw")
    public suspend fun triggeringLogic(`value`: Output<AutomationRuleTriggeringLogicArgs>) {
        this.triggeringLogic = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("xcehmbrodjddfsjy")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The actions to execute when the automation rule is triggered.
     */
    @JvmName("fufyidnketnjqtwe")
    public suspend
    fun actions(`value`: List<Either<AutomationRuleModifyPropertiesActionArgs, AutomationRuleRunPlaybookActionArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values The actions to execute when the automation rule is triggered.
     */
    @JvmName("mjkbrlhiihklhtqt")
    public suspend fun actions(
        vararg
        values: Either<AutomationRuleModifyPropertiesActionArgs, AutomationRuleRunPlaybookActionArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Automation rule ID
     */
    @JvmName("mdpposljioxluduc")
    public suspend fun automationRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationRuleId = mapped
    }

    /**
     * @param value The display name of the automation rule.
     */
    @JvmName("uilssfrbspwmpgbu")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The order of execution of the automation rule.
     */
    @JvmName("pdubdtjgiuaqscsd")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("axafhwmcwkvrkrjw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Describes automation rule triggering logic.
     */
    @JvmName("elvyhikhlaokstei")
    public suspend fun triggeringLogic(`value`: AutomationRuleTriggeringLogicArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggeringLogic = mapped
    }

    /**
     * @param argument Describes automation rule triggering logic.
     */
    @JvmName("daeomsnjqxbcvcmv")
    public suspend
    fun triggeringLogic(argument: suspend AutomationRuleTriggeringLogicArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRuleTriggeringLogicArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.triggeringLogic = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fxrdqqyurjxxqprq")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): AutomationRuleArgs = AutomationRuleArgs(
        actions = actions,
        automationRuleId = automationRuleId,
        displayName = displayName,
        order = order,
        resourceGroupName = resourceGroupName,
        triggeringLogic = triggeringLogic,
        workspaceName = workspaceName,
    )
}
