@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.CustomizableConnectionsConfigResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.CustomizableConnectorUiConfigResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securityinsights.kotlin.outputs.CustomizableConnectionsConfigResponse.Companion.toKotlin as customizableConnectionsConfigResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.CustomizableConnectorUiConfigResponse.Companion.toKotlin as customizableConnectorUiConfigResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CustomizableConnectorDefinition].
 */
@PulumiTagMarker
public class CustomizableConnectorDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomizableConnectorDefinitionArgs = CustomizableConnectorDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomizableConnectorDefinitionArgsBuilder.() -> Unit) {
        val builder = CustomizableConnectorDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomizableConnectorDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomizableConnectorDefinition(builtJavaResource)
    }
}

/**
 * Connector definition for kind 'Customizable'.
 * Azure REST API version: 2023-07-01-preview.
 * ## Example Usage
 * ### Create data connector definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customizableConnectorDefinition = new AzureNative.SecurityInsights.CustomizableConnectorDefinition("customizableConnectorDefinition", new()
 *     {
 *         ConnectorUiConfig = new AzureNative.SecurityInsights.Inputs.CustomizableConnectorUiConfigArgs
 *         {
 *             Availability = new AzureNative.SecurityInsights.Inputs.ConnectorDefinitionsAvailabilityArgs
 *             {
 *                 IsPreview = false,
 *                 Status = 1,
 *             },
 *             ConnectivityCriteria = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.ConnectivityCriterionArgs
 *                 {
 *                     Type = "IsConnectedQuery",
 *                     Value = new[]
 *                     {
 *                         @"GitHubAuditLogPolling_CL
 *  | summarize LastLogReceived = max(TimeGenerated)
 *  | project IsConnected = LastLogReceived > ago(30d)",
 *                     },
 *                 },
 *             },
 *             DataTypes = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.ConnectorDataTypeArgs
 *                 {
 *                     LastDataReceivedQuery = @"GitHubAuditLogPolling_CL
 *             | summarize Time = max(TimeGenerated)
 *             | where isnotempty(Time)",
 *                     Name = "GitHubAuditLogPolling_CL",
 *                 },
 *             },
 *             DescriptionMarkdown = "The GitHub audit log connector provides the capability to ingest GitHub logs into Azure Sentinel. By connecting GitHub audit logs into Azure Sentinel, you can view this data in workbooks, use it to create custom alerts, and improve your investigation process.",
 *             GraphQueries = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.GraphQueryArgs
 *                 {
 *                     BaseQuery = "GitHubAuditLogPolling_CL",
 *                     Legend = "GitHub audit log events",
 *                     MetricName = "Total events received",
 *                 },
 *             },
 *             InstructionSteps = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.InstructionStepArgs
 *                 {
 *                     Description = @"Enable GitHub audit Logs.
 *  Follow [this](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token) to create or find your personal key",
 *                     Instructions = new[]
 *                     {
 *                         new AzureNative.SecurityInsights.Inputs.InstructionStepDetailsArgs
 *                         {
 *                             Parameters = new Dictionary<string, object?>
 *                             {
 *                                 ["clientIdLabel"] = "Client ID",
 *                                 ["clientSecretLabel"] = "Client Secret",
 *                                 ["connectButtonLabel"] = "Connect",
 *                                 ["disconnectButtonLabel"] = "Disconnect",
 *                             },
 *                             Type = "OAuthForm",
 *                         },
 *                     },
 *                     Title = "Connect GitHub Enterprise Audit Log to Azure Sentinel",
 *                 },
 *             },
 *             Permissions = new AzureNative.SecurityInsights.Inputs.ConnectorDefinitionsPermissionsArgs
 *             {
 *                 Customs = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.CustomPermissionDetailsArgs
 *                     {
 *                         Description = "You need access to GitHub personal token, the key should have 'admin:org' scope",
 *                         Name = "GitHub API personal token Key",
 *                     },
 *                 },
 *                 ResourceProvider = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.ConnectorDefinitionsResourceProviderArgs
 *                     {
 *                         PermissionsDisplayText = "read and write permissions are required.",
 *                         Provider = "Microsoft.OperationalInsights/workspaces",
 *                         ProviderDisplayName = "Workspace",
 *                         RequiredPermissions = new AzureNative.SecurityInsights.Inputs.ResourceProviderRequiredPermissionsArgs
 *                         {
 *                             Action = false,
 *                             Delete = false,
 *                             Read = false,
 *                             Write = true,
 *                         },
 *                         Scope = AzureNative.SecurityInsights.ProviderPermissionsScope.Workspace,
 *                     },
 *                 },
 *             },
 *             Publisher = "GitHub",
 *             SampleQueries = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.SampleQueryArgs
 *                 {
 *                     Description = "All logs",
 *                     Query = @"GitHubAuditLogPolling_CL
 *  | take 10",
 *                 },
 *             },
 *             Title = "GitHub Enterprise Audit Log",
 *         },
 *         DataConnectorDefinitionName = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Kind = "Customizable",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := securityinsights.NewCustomizableConnectorDefinition(ctx, "customizableConnectorDefinition", &securityinsights.CustomizableConnectorDefinitionArgs{
 * ConnectorUiConfig: &securityinsights.CustomizableConnectorUiConfigArgs{
 * Availability: &securityinsights.ConnectorDefinitionsAvailabilityArgs{
 * IsPreview: pulumi.Bool(false),
 * Status: pulumi.Int(1),
 * },
 * ConnectivityCriteria: securityinsights.ConnectivityCriterionArray{
 * &securityinsights.ConnectivityCriterionArgs{
 * Type: pulumi.String("IsConnectedQuery"),
 * Value: pulumi.StringArray{
 * pulumi.String("GitHubAuditLogPolling_CL \n | summarize LastLogReceived = max(TimeGenerated)\n | project IsConnected = LastLogReceived > ago(30d)"),
 * },
 * },
 * },
 * DataTypes: securityinsights.ConnectorDataTypeArray{
 * &securityinsights.ConnectorDataTypeArgs{
 * LastDataReceivedQuery: pulumi.String("GitHubAuditLogPolling_CL \n            | summarize Time = max(TimeGenerated)\n            | where isnotempty(Time)"),
 * Name: pulumi.String("GitHubAuditLogPolling_CL"),
 * },
 * },
 * DescriptionMarkdown: pulumi.String("The GitHub audit log connector provides the capability to ingest GitHub logs into Azure Sentinel. By connecting GitHub audit logs into Azure Sentinel, you can view this data in workbooks, use it to create custom alerts, and improve your investigation process."),
 * GraphQueries: securityinsights.GraphQueryArray{
 * &securityinsights.GraphQueryArgs{
 * BaseQuery: pulumi.String("GitHubAuditLogPolling_CL"),
 * Legend: pulumi.String("GitHub audit log events"),
 * MetricName: pulumi.String("Total events received"),
 * },
 * },
 * InstructionSteps: []securityinsights.InstructionStepArgs{
 * {
 * Description: pulumi.String("Enable GitHub audit Logs. \n Follow [this](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token) to create or find your personal key"),
 * Instructions: securityinsights.InstructionStepDetailsArray{
 * {
 * Parameters: pulumi.Any({
 * "clientIdLabel": "Client ID",
 * "clientSecretLabel": "Client Secret",
 * "connectButtonLabel": "Connect",
 * "disconnectButtonLabel": "Disconnect",
 * }),
 * Type: pulumi.String("OAuthForm"),
 * },
 * },
 * Title: pulumi.String("Connect GitHub Enterprise Audit Log to Azure Sentinel"),
 * },
 * },
 * Permissions: &securityinsights.ConnectorDefinitionsPermissionsArgs{
 * Customs: securityinsights.CustomPermissionDetailsArray{
 * &securityinsights.CustomPermissionDetailsArgs{
 * Description: pulumi.String("You need access to GitHub personal token, the key should have 'admin:org' scope"),
 * Name: pulumi.String("GitHub API personal token Key"),
 * },
 * },
 * ResourceProvider: securityinsights.ConnectorDefinitionsResourceProviderArray{
 * &securityinsights.ConnectorDefinitionsResourceProviderArgs{
 * PermissionsDisplayText: pulumi.String("read and write permissions are required."),
 * Provider: pulumi.String("Microsoft.OperationalInsights/workspaces"),
 * ProviderDisplayName: pulumi.String("Workspace"),
 * RequiredPermissions: &securityinsights.ResourceProviderRequiredPermissionsArgs{
 * Action: pulumi.Bool(false),
 * Delete: pulumi.Bool(false),
 * Read: pulumi.Bool(false),
 * Write: pulumi.Bool(true),
 * },
 * Scope: pulumi.String(securityinsights.ProviderPermissionsScopeWorkspace),
 * },
 * },
 * },
 * Publisher: pulumi.String("GitHub"),
 * SampleQueries: securityinsights.SampleQueryArray{
 * &securityinsights.SampleQueryArgs{
 * Description: pulumi.String("All logs"),
 * Query: pulumi.String("GitHubAuditLogPolling_CL \n | take 10"),
 * },
 * },
 * Title: pulumi.String("GitHub Enterprise Audit Log"),
 * },
 * DataConnectorDefinitionName: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * Kind: pulumi.String("Customizable"),
 * ResourceGroupName: pulumi.String("myRg"),
 * WorkspaceName: pulumi.String("myWorkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinition;
 * import com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinitionArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectorUiConfigArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsAvailabilityArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsPermissionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customizableConnectorDefinition = new CustomizableConnectorDefinition("customizableConnectorDefinition", CustomizableConnectorDefinitionArgs.builder()
 *             .connectorUiConfig(CustomizableConnectorUiConfigArgs.builder()
 *                 .availability(ConnectorDefinitionsAvailabilityArgs.builder()
 *                     .isPreview(false)
 *                     .status(1)
 *                     .build())
 *                 .connectivityCriteria(ConnectivityCriterionArgs.builder()
 *                     .type("IsConnectedQuery")
 *                     .value("""
 * GitHubAuditLogPolling_CL
 *  | summarize LastLogReceived = max(TimeGenerated)
 *  | project IsConnected = LastLogReceived > ago(30d)                    """)
 *                     .build())
 *                 .dataTypes(ConnectorDataTypeArgs.builder()
 *                     .lastDataReceivedQuery("""
 * GitHubAuditLogPolling_CL
 *             | summarize Time = max(TimeGenerated)
 *             | where isnotempty(Time)                    """)
 *                     .name("GitHubAuditLogPolling_CL")
 *                     .build())
 *                 .descriptionMarkdown("The GitHub audit log connector provides the capability to ingest GitHub logs into Azure Sentinel. By connecting GitHub audit logs into Azure Sentinel, you can view this data in workbooks, use it to create custom alerts, and improve your investigation process.")
 *                 .graphQueries(GraphQueryArgs.builder()
 *                     .baseQuery("GitHubAuditLogPolling_CL")
 *                     .legend("GitHub audit log events")
 *                     .metricName("Total events received")
 *                     .build())
 *                 .instructionSteps(InstructionStepArgs.builder()
 *                     .description("""
 * Enable GitHub audit Logs.
 *  Follow [this](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token) to create or find your personal key                    """)
 *                     .instructions(InstructionStepDetailsArgs.builder()
 *                         .parameters(Map.ofEntries(
 *                             Map.entry("clientIdLabel", "Client ID"),
 *                             Map.entry("clientSecretLabel", "Client Secret"),
 *                             Map.entry("connectButtonLabel", "Connect"),
 *                             Map.entry("disconnectButtonLabel", "Disconnect")
 *                         ))
 *                         .type("OAuthForm")
 *                         .build())
 *                     .title("Connect GitHub Enterprise Audit Log to Azure Sentinel")
 *                     .build())
 *                 .permissions(ConnectorDefinitionsPermissionsArgs.builder()
 *                     .customs(CustomPermissionDetailsArgs.builder()
 *                         .description("You need access to GitHub personal token, the key should have 'admin:org' scope")
 *                         .name("GitHub API personal token Key")
 *                         .build())
 *                     .resourceProvider(ConnectorDefinitionsResourceProviderArgs.builder()
 *                         .permissionsDisplayText("read and write permissions are required.")
 *                         .provider("Microsoft.OperationalInsights/workspaces")
 *                         .providerDisplayName("Workspace")
 *                         .requiredPermissions(ResourceProviderRequiredPermissionsArgs.builder()
 *                             .action(false)
 *                             .delete(false)
 *                             .read(false)
 *                             .write(true)
 *                             .build())
 *                         .scope("Workspace")
 *                         .build())
 *                     .build())
 *                 .publisher("GitHub")
 *                 .sampleQueries(SampleQueryArgs.builder()
 *                     .description("All logs")
 *                     .query("""
 * GitHubAuditLogPolling_CL
 *  | take 10                    """)
 *                     .build())
 *                 .title("GitHub Enterprise Audit Log")
 *                 .build())
 *             .dataConnectorDefinitionName("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .kind("Customizable")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:CustomizableConnectorDefinition 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}
 * ```
 */
public class CustomizableConnectorDefinition internal constructor(
    override val javaResource:
    com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinition,
) : KotlinCustomResource(javaResource, CustomizableConnectorDefinitionMapper) {
    /**
     * The UiConfig for 'Customizable' connector definition kind.
     */
    public val connectionsConfig: Output<CustomizableConnectionsConfigResponse>?
        get() = javaResource.connectionsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customizableConnectionsConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The UiConfig for 'Customizable' connector definition kind.
     */
    public val connectorUiConfig: Output<CustomizableConnectorUiConfigResponse>
        get() = javaResource.connectorUiConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                customizableConnectorUiConfigResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the connector definition created date in UTC format.
     */
    public val createdTimeUtc: Output<String>?
        get() = javaResource.createdTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the data connector definitions
     * Expected value is 'Customizable'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the connector definition last modified date in UTC format.
     */
    public val lastModifiedUtc: Output<String>?
        get() = javaResource.lastModifiedUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomizableConnectorDefinitionMapper :
    ResourceMapper<CustomizableConnectorDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinition::class == javaResource::class

    override fun map(javaResource: Resource): CustomizableConnectorDefinition =
        CustomizableConnectorDefinition(
            javaResource as
                com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinition,
        )
}

/**
 * @see [CustomizableConnectorDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomizableConnectorDefinition].
 */
public suspend fun customizableConnectorDefinition(
    name: String,
    block: suspend CustomizableConnectorDefinitionResourceBuilder.() -> Unit,
):
    CustomizableConnectorDefinition {
    val builder = CustomizableConnectorDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomizableConnectorDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customizableConnectorDefinition(name: String): CustomizableConnectorDefinition {
    val builder = CustomizableConnectorDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
