@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.HuntArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AttackTactic
import com.pulumi.azurenative.securityinsights.kotlin.enums.HypothesisStatus
import com.pulumi.azurenative.securityinsights.kotlin.enums.Status
import com.pulumi.azurenative.securityinsights.kotlin.inputs.HuntOwnerArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.HuntOwnerArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a Hunt in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a hunt.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hunt = new AzureNative.SecurityInsights.Hunt("hunt", new()
 *     {
 *         AttackTactics = new[]
 *         {
 *             AzureNative.SecurityInsights.AttackTactic.Reconnaissance,
 *         },
 *         AttackTechniques = new[]
 *         {
 *             "T1595",
 *         },
 *         Description = "Log4J Hunt Description",
 *         DisplayName = "Log4J new hunt",
 *         HuntId = "163e7b2a-a2ec-4041-aaba-d878a38f265f",
 *         HypothesisStatus = AzureNative.SecurityInsights.HypothesisStatus.Unknown,
 *         Labels = new[]
 *         {
 *             "Label1",
 *             "Label2",
 *         },
 *         Owner = new AzureNative.SecurityInsights.Inputs.HuntOwnerArgs
 *         {
 *             ObjectId = "873b5263-5d34-4149-b356-ad341b01e123",
 *         },
 *         ResourceGroupName = "myRg",
 *         Status = AzureNative.SecurityInsights.Status.New,
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewHunt(ctx, "hunt", &securityinsights.HuntArgs{
 * 			AttackTactics: pulumi.StringArray{
 * 				pulumi.String(securityinsights.AttackTacticReconnaissance),
 * 			},
 * 			AttackTechniques: pulumi.StringArray{
 * 				pulumi.String("T1595"),
 * 			},
 * 			Description:      pulumi.String("Log4J Hunt Description"),
 * 			DisplayName:      pulumi.String("Log4J new hunt"),
 * 			HuntId:           pulumi.String("163e7b2a-a2ec-4041-aaba-d878a38f265f"),
 * 			HypothesisStatus: pulumi.String(securityinsights.HypothesisStatusUnknown),
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("Label1"),
 * 				pulumi.String("Label2"),
 * 			},
 * 			Owner: &securityinsights.HuntOwnerArgs{
 * 				ObjectId: pulumi.String("873b5263-5d34-4149-b356-ad341b01e123"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Status:            pulumi.String(securityinsights.StatusNew),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Hunt;
 * import com.pulumi.azurenative.securityinsights.HuntArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.HuntOwnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hunt = new Hunt("hunt", HuntArgs.builder()
 *             .attackTactics("Reconnaissance")
 *             .attackTechniques("T1595")
 *             .description("Log4J Hunt Description")
 *             .displayName("Log4J new hunt")
 *             .huntId("163e7b2a-a2ec-4041-aaba-d878a38f265f")
 *             .hypothesisStatus("Unknown")
 *             .labels(
 *                 "Label1",
 *                 "Label2")
 *             .owner(HuntOwnerArgs.builder()
 *                 .objectId("873b5263-5d34-4149-b356-ad341b01e123")
 *                 .build())
 *             .resourceGroupName("myRg")
 *             .status("New")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Hunt 163e7b2a-a2ec-4041-aaba-d878a38f265f /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}
 * ```
 * @property attackTactics A list of mitre attack tactics the hunt is associated with
 * @property attackTechniques A list of a mitre attack techniques the hunt is associated with
 * @property description The description of the hunt
 * @property displayName The display name of the hunt
 * @property huntId The hunt id (GUID)
 * @property hypothesisStatus The hypothesis status of the hunt.
 * @property labels List of labels relevant to this hunt
 * @property owner Describes a user that the hunt is assigned to
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property status The status of the hunt.
 * @property workspaceName The name of the workspace.
 */
public data class HuntArgs(
    public val attackTactics: Output<List<Either<String, AttackTactic>>>? = null,
    public val attackTechniques: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val huntId: Output<String>? = null,
    public val hypothesisStatus: Output<Either<String, HypothesisStatus>>? = null,
    public val labels: Output<List<String>>? = null,
    public val owner: Output<HuntOwnerArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, Status>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.HuntArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.HuntArgs =
        com.pulumi.azurenative.securityinsights.HuntArgs.builder()
            .attackTactics(
                attackTactics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .attackTechniques(attackTechniques?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .huntId(huntId?.applyValue({ args0 -> args0 }))
            .hypothesisStatus(
                hypothesisStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .owner(owner?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HuntArgs].
 */
@PulumiTagMarker
public class HuntArgsBuilder internal constructor() {
    private var attackTactics: Output<List<Either<String, AttackTactic>>>? = null

    private var attackTechniques: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var huntId: Output<String>? = null

    private var hypothesisStatus: Output<Either<String, HypothesisStatus>>? = null

    private var labels: Output<List<String>>? = null

    private var owner: Output<HuntOwnerArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, Status>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value A list of mitre attack tactics the hunt is associated with
     */
    @JvmName("ryokuwteykhbswif")
    public suspend fun attackTactics(`value`: Output<List<Either<String, AttackTactic>>>) {
        this.attackTactics = value
    }

    @JvmName("mqrrabhoihaigfxq")
    public suspend fun attackTactics(vararg values: Output<Either<String, AttackTactic>>) {
        this.attackTactics = Output.all(values.asList())
    }

    /**
     * @param values A list of mitre attack tactics the hunt is associated with
     */
    @JvmName("yyovrljfbdbfrrid")
    public suspend fun attackTactics(values: List<Output<Either<String, AttackTactic>>>) {
        this.attackTactics = Output.all(values)
    }

    /**
     * @param value A list of a mitre attack techniques the hunt is associated with
     */
    @JvmName("twtaaopokessnqwu")
    public suspend fun attackTechniques(`value`: Output<List<String>>) {
        this.attackTechniques = value
    }

    @JvmName("hmbjhkdipnxdpncr")
    public suspend fun attackTechniques(vararg values: Output<String>) {
        this.attackTechniques = Output.all(values.asList())
    }

    /**
     * @param values A list of a mitre attack techniques the hunt is associated with
     */
    @JvmName("okrvdagosvkxlrum")
    public suspend fun attackTechniques(values: List<Output<String>>) {
        this.attackTechniques = Output.all(values)
    }

    /**
     * @param value The description of the hunt
     */
    @JvmName("xquygiaunbmdywph")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the hunt
     */
    @JvmName("caonwrovsghcmwon")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The hunt id (GUID)
     */
    @JvmName("sqnxapmcijtpyoqs")
    public suspend fun huntId(`value`: Output<String>) {
        this.huntId = value
    }

    /**
     * @param value The hypothesis status of the hunt.
     */
    @JvmName("ugvxtqgldxqxhjvg")
    public suspend fun hypothesisStatus(`value`: Output<Either<String, HypothesisStatus>>) {
        this.hypothesisStatus = value
    }

    /**
     * @param value List of labels relevant to this hunt
     */
    @JvmName("oxulosfpxsrwcjbp")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("ckrhucarusnnhnyk")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of labels relevant to this hunt
     */
    @JvmName("rvtsmwtwvfqbepvq")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Describes a user that the hunt is assigned to
     */
    @JvmName("aafwhrojichdxjwq")
    public suspend fun owner(`value`: Output<HuntOwnerArgs>) {
        this.owner = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vnacdvprevrvpplt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The status of the hunt.
     */
    @JvmName("thqvbjlutrkesbwt")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mgddmswwdflvvcgy")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value A list of mitre attack tactics the hunt is associated with
     */
    @JvmName("kghhwdrkvoeanful")
    public suspend fun attackTactics(`value`: List<Either<String, AttackTactic>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attackTactics = mapped
    }

    /**
     * @param values A list of mitre attack tactics the hunt is associated with
     */
    @JvmName("nrwvdlraxolugqbm")
    public suspend fun attackTactics(vararg values: Either<String, AttackTactic>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attackTactics = mapped
    }

    /**
     * @param value A list of a mitre attack techniques the hunt is associated with
     */
    @JvmName("paptklivesyyqhdm")
    public suspend fun attackTechniques(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attackTechniques = mapped
    }

    /**
     * @param values A list of a mitre attack techniques the hunt is associated with
     */
    @JvmName("obnyoqxgntkdgifa")
    public suspend fun attackTechniques(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attackTechniques = mapped
    }

    /**
     * @param value The description of the hunt
     */
    @JvmName("nwbejhivlqvomwxb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the hunt
     */
    @JvmName("xwdqyxffjcxrjcao")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The hunt id (GUID)
     */
    @JvmName("mnocxhakcekkuyyi")
    public suspend fun huntId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.huntId = mapped
    }

    /**
     * @param value The hypothesis status of the hunt.
     */
    @JvmName("qwnwmydyyvoipwas")
    public suspend fun hypothesisStatus(`value`: Either<String, HypothesisStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hypothesisStatus = mapped
    }

    /**
     * @param value The hypothesis status of the hunt.
     */
    @JvmName("yreykeykbndowgng")
    public fun hypothesisStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HypothesisStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hypothesisStatus = mapped
    }

    /**
     * @param value The hypothesis status of the hunt.
     */
    @JvmName("debxwedcccxpchmf")
    public fun hypothesisStatus(`value`: HypothesisStatus) {
        val toBeMapped = Either.ofRight<String, HypothesisStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hypothesisStatus = mapped
    }

    /**
     * @param value List of labels relevant to this hunt
     */
    @JvmName("asviodctiiwhqutv")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of labels relevant to this hunt
     */
    @JvmName("dbpalvrgecrdndwt")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Describes a user that the hunt is assigned to
     */
    @JvmName("nupyxaugloxowhmw")
    public suspend fun owner(`value`: HuntOwnerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param argument Describes a user that the hunt is assigned to
     */
    @JvmName("imtypilhslrpgwiy")
    public suspend fun owner(argument: suspend HuntOwnerArgsBuilder.() -> Unit) {
        val toBeMapped = HuntOwnerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.owner = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nwtjxwwokoxnmfcb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The status of the hunt.
     */
    @JvmName("ufsgrweoipftseuw")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the hunt.
     */
    @JvmName("pixqllawhoeooycn")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the hunt.
     */
    @JvmName("lmtkqvffspmtpody")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ycasprwgpfewskhw")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): HuntArgs = HuntArgs(
        attackTactics = attackTactics,
        attackTechniques = attackTechniques,
        description = description,
        displayName = displayName,
        huntId = huntId,
        hypothesisStatus = hypothesisStatus,
        labels = labels,
        owner = owner,
        resourceGroupName = resourceGroupName,
        status = status,
        workspaceName = workspaceName,
    )
}
