@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.HuntCommentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Hunt Comment in Azure Security Insights
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a hunt comment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var huntComment = new AzureNative.SecurityInsights.HuntComment("huntComment", new()
 *     {
 *         HuntCommentId = "2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         HuntId = "163e7b2a-a2ec-4041-aaba-d878a38f265f",
 *         Message = "This is a test comment.",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewHuntComment(ctx, "huntComment", &securityinsights.HuntCommentArgs{
 * 			HuntCommentId:     pulumi.String("2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			HuntId:            pulumi.String("163e7b2a-a2ec-4041-aaba-d878a38f265f"),
 * 			Message:           pulumi.String("This is a test comment."),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.HuntComment;
 * import com.pulumi.azurenative.securityinsights.HuntCommentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var huntComment = new HuntComment("huntComment", HuntCommentArgs.builder()
 *             .huntCommentId("2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .huntId("163e7b2a-a2ec-4041-aaba-d878a38f265f")
 *             .message("This is a test comment.")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:HuntComment 2216d0e1-91e3-4902-89fd-d2df8c123456 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/comments/{huntCommentId}
 * ```
 * @property huntCommentId The hunt comment id (GUID)
 * @property huntId The hunt id (GUID)
 * @property message The message for the comment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class HuntCommentArgs(
    public val huntCommentId: Output<String>? = null,
    public val huntId: Output<String>? = null,
    public val message: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.HuntCommentArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.HuntCommentArgs =
        com.pulumi.azurenative.securityinsights.HuntCommentArgs.builder()
            .huntCommentId(huntCommentId?.applyValue({ args0 -> args0 }))
            .huntId(huntId?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HuntCommentArgs].
 */
@PulumiTagMarker
public class HuntCommentArgsBuilder internal constructor() {
    private var huntCommentId: Output<String>? = null

    private var huntId: Output<String>? = null

    private var message: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The hunt comment id (GUID)
     */
    @JvmName("fwbidqphnagvcxfx")
    public suspend fun huntCommentId(`value`: Output<String>) {
        this.huntCommentId = value
    }

    /**
     * @param value The hunt id (GUID)
     */
    @JvmName("hqrqbmggrynqvjok")
    public suspend fun huntId(`value`: Output<String>) {
        this.huntId = value
    }

    /**
     * @param value The message for the comment
     */
    @JvmName("hwrypfarwqmcdyli")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rrotrepjlkplfnjk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ulfijfwhsecnauxt")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The hunt comment id (GUID)
     */
    @JvmName("uduotlhubpriohab")
    public suspend fun huntCommentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.huntCommentId = mapped
    }

    /**
     * @param value The hunt id (GUID)
     */
    @JvmName("bvylerptyydhjxsh")
    public suspend fun huntId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.huntId = mapped
    }

    /**
     * @param value The message for the comment
     */
    @JvmName("xrgomkhyrwpyvkgp")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hnmxjgbndgifktrr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("khjmcmbdvcvundxg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): HuntCommentArgs = HuntCommentArgs(
        huntCommentId = huntCommentId,
        huntId = huntId,
        message = message,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
