@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.IncidentTaskArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentTaskStatus
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ClientInfoArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ClientInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### IncidentTasks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incidentTask = new AzureNative.SecurityInsights.IncidentTask("incidentTask", new()
 *     {
 *         Description = "Task description",
 *         IncidentId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         IncidentTaskId = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         ResourceGroupName = "myRg",
 *         Status = AzureNative.SecurityInsights.IncidentTaskStatus.New,
 *         Title = "Task title",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncidentTask(ctx, "incidentTask", &securityinsights.IncidentTaskArgs{
 * 			Description:       pulumi.String("Task description"),
 * 			IncidentId:        pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			IncidentTaskId:    pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Status:            pulumi.String(securityinsights.IncidentTaskStatusNew),
 * 			Title:             pulumi.String("Task title"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.IncidentTask;
 * import com.pulumi.azurenative.securityinsights.IncidentTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incidentTask = new IncidentTask("incidentTask", IncidentTaskArgs.builder()
 *             .description("Task description")
 *             .incidentId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .incidentTaskId("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .resourceGroupName("myRg")
 *             .status("New")
 *             .title("Task title")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:IncidentTask 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}
 * ```
 * @property createdBy Information on the client (user or application) that made some action
 * @property description The description of the task
 * @property incidentId Incident ID
 * @property incidentTaskId Incident task ID
 * @property lastModifiedBy Information on the client (user or application) that made some action
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property status
 * @property title The title of the task
 * @property workspaceName The name of the workspace.
 */
public data class IncidentTaskArgs(
    public val createdBy: Output<ClientInfoArgs>? = null,
    public val description: Output<String>? = null,
    public val incidentId: Output<String>? = null,
    public val incidentTaskId: Output<String>? = null,
    public val lastModifiedBy: Output<ClientInfoArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, IncidentTaskStatus>>? = null,
    public val title: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.IncidentTaskArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.IncidentTaskArgs =
        com.pulumi.azurenative.securityinsights.IncidentTaskArgs.builder()
            .createdBy(createdBy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .incidentId(incidentId?.applyValue({ args0 -> args0 }))
            .incidentTaskId(incidentTaskId?.applyValue({ args0 -> args0 }))
            .lastModifiedBy(lastModifiedBy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .title(title?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncidentTaskArgs].
 */
@PulumiTagMarker
public class IncidentTaskArgsBuilder internal constructor() {
    private var createdBy: Output<ClientInfoArgs>? = null

    private var description: Output<String>? = null

    private var incidentId: Output<String>? = null

    private var incidentTaskId: Output<String>? = null

    private var lastModifiedBy: Output<ClientInfoArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, IncidentTaskStatus>>? = null

    private var title: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Information on the client (user or application) that made some action
     */
    @JvmName("peuaqehedwewqrvf")
    public suspend fun createdBy(`value`: Output<ClientInfoArgs>) {
        this.createdBy = value
    }

    /**
     * @param value The description of the task
     */
    @JvmName("suxowbwpmuiiqgrm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Incident ID
     */
    @JvmName("hnmutbtvwcyjofji")
    public suspend fun incidentId(`value`: Output<String>) {
        this.incidentId = value
    }

    /**
     * @param value Incident task ID
     */
    @JvmName("badmsfiqxtbdchse")
    public suspend fun incidentTaskId(`value`: Output<String>) {
        this.incidentTaskId = value
    }

    /**
     * @param value Information on the client (user or application) that made some action
     */
    @JvmName("irxhndeforakpxbw")
    public suspend fun lastModifiedBy(`value`: Output<ClientInfoArgs>) {
        this.lastModifiedBy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hkraquqnnjkirhpn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("jvyhwyswrdjrkfax")
    public suspend fun status(`value`: Output<Either<String, IncidentTaskStatus>>) {
        this.status = value
    }

    /**
     * @param value The title of the task
     */
    @JvmName("qctclwqlvrwyeloj")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("oxiagkkjddkwhqij")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Information on the client (user or application) that made some action
     */
    @JvmName("axrudygyyxbbhbvi")
    public suspend fun createdBy(`value`: ClientInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBy = mapped
    }

    /**
     * @param argument Information on the client (user or application) that made some action
     */
    @JvmName("wsamjivyoagntvrp")
    public suspend fun createdBy(argument: suspend ClientInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClientInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.createdBy = mapped
    }

    /**
     * @param value The description of the task
     */
    @JvmName("rwdvlexqisoexfdn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Incident ID
     */
    @JvmName("gjrjyifuiaenfhvs")
    public suspend fun incidentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentId = mapped
    }

    /**
     * @param value Incident task ID
     */
    @JvmName("aottsyqpoisqnduc")
    public suspend fun incidentTaskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentTaskId = mapped
    }

    /**
     * @param value Information on the client (user or application) that made some action
     */
    @JvmName("fmrpfetolkcbcpsn")
    public suspend fun lastModifiedBy(`value`: ClientInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedBy = mapped
    }

    /**
     * @param argument Information on the client (user or application) that made some action
     */
    @JvmName("vbocmpdyrpcdhapi")
    public suspend fun lastModifiedBy(argument: suspend ClientInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClientInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lastModifiedBy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pcetsjpjyctjpwxr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("iauoajdywglgbwcg")
    public suspend fun status(`value`: Either<String, IncidentTaskStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("qoogrigoukrnvcfj")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentTaskStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("wpudkeulyflsscqn")
    public fun status(`value`: IncidentTaskStatus) {
        val toBeMapped = Either.ofRight<String, IncidentTaskStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The title of the task
     */
    @JvmName("gvcyjghkaskcqscq")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("lvjpgenryloldvko")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IncidentTaskArgs = IncidentTaskArgs(
        createdBy = createdBy,
        description = description,
        incidentId = incidentId,
        incidentTaskId = incidentTaskId,
        lastModifiedBy = lastModifiedBy,
        resourceGroupName = resourceGroupName,
        status = status,
        title = title,
        workspaceName = workspaceName,
    )
}
