@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MicrosoftSecurityIncidentCreationAlertRule].
 */
@PulumiTagMarker
public class MicrosoftSecurityIncidentCreationAlertRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MicrosoftSecurityIncidentCreationAlertRuleArgs =
        MicrosoftSecurityIncidentCreationAlertRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend MicrosoftSecurityIncidentCreationAlertRuleArgsBuilder.() -> Unit) {
        val builder = MicrosoftSecurityIncidentCreationAlertRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MicrosoftSecurityIncidentCreationAlertRule {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MicrosoftSecurityIncidentCreationAlertRule(builtJavaResource)
    }
}

/**
 * Represents MicrosoftSecurityIncidentCreation rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates a Fusion alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var microsoftSecurityIncidentCreationAlertRule = new AzureNative.SecurityInsights.MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "myFirstFusionRule",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMicrosoftSecurityIncidentCreationAlertRule(ctx, "microsoftSecurityIncidentCreationAlertRule", &securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("myFirstFusionRule"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var microsoftSecurityIncidentCreationAlertRule = new MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", MicrosoftSecurityIncidentCreationAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("myFirstFusionRule")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a MicrosoftSecurityIncidentCreation rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var microsoftSecurityIncidentCreationAlertRule = new AzureNative.SecurityInsights.MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", new()
 *     {
 *         DisplayName = "testing displayname",
 *         Enabled = true,
 *         Kind = "MicrosoftSecurityIncidentCreation",
 *         ProductFilter = AzureNative.SecurityInsights.MicrosoftSecurityProductName.Microsoft_Cloud_App_Security,
 *         ResourceGroupName = "myRg",
 *         RuleId = "microsoftSecurityIncidentCreationRuleExample",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMicrosoftSecurityIncidentCreationAlertRule(ctx, "microsoftSecurityIncidentCreationAlertRule", &securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs{
 * 			DisplayName:       pulumi.String("testing displayname"),
 * 			Enabled:           pulumi.Bool(true),
 * 			Kind:              pulumi.String("MicrosoftSecurityIncidentCreation"),
 * 			ProductFilter:     pulumi.String(securityinsights.MicrosoftSecurityProductName_Microsoft_Cloud_App_Security),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("microsoftSecurityIncidentCreationRuleExample"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var microsoftSecurityIncidentCreationAlertRule = new MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", MicrosoftSecurityIncidentCreationAlertRuleArgs.builder()
 *             .displayName("testing displayname")
 *             .enabled(true)
 *             .kind("MicrosoftSecurityIncidentCreation")
 *             .productFilter("Microsoft Cloud App Security")
 *             .resourceGroupName("myRg")
 *             .ruleId("microsoftSecurityIncidentCreationRuleExample")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a Scheduled alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var microsoftSecurityIncidentCreationAlertRule = new AzureNative.SecurityInsights.MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMicrosoftSecurityIncidentCreationAlertRule(ctx, "microsoftSecurityIncidentCreationAlertRule", &securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule;
 * import com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var microsoftSecurityIncidentCreationAlertRule = new MicrosoftSecurityIncidentCreationAlertRule("microsoftSecurityIncidentCreationAlertRule", MicrosoftSecurityIncidentCreationAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:MicrosoftSecurityIncidentCreationAlertRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/alertRules/{ruleId}
 * ```
 */
public class MicrosoftSecurityIncidentCreationAlertRule internal constructor(
    override val javaResource:
    com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule,
) : KotlinCustomResource(javaResource, MicrosoftSecurityIncidentCreationAlertRuleMapper) {
    /**
     * The Name of the alert rule template used to create this rule.
     */
    public val alertRuleTemplateName: Output<String>?
        get() = javaResource.alertRuleTemplateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the alert rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name for alerts created by this alert rule.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * the alerts' displayNames on which the cases will not be generated
     */
    public val displayNamesExcludeFilter: Output<List<String>>?
        get() = javaResource.displayNamesExcludeFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * the alerts' displayNames on which the cases will be generated
     */
    public val displayNamesFilter: Output<List<String>>?
        get() = javaResource.displayNamesFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Determines whether this alert rule is enabled or disabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the alert rule
     * Expected value is 'MicrosoftSecurityIncidentCreation'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The last time that this alert has been modified.
     */
    public val lastModifiedUtc: Output<String>
        get() = javaResource.lastModifiedUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The alerts' productName on which the cases will be generated
     */
    public val productFilter: Output<String>
        get() = javaResource.productFilter().applyValue({ args0 -> args0 })

    /**
     * the alerts' severities on which the cases will be generated
     */
    public val severitiesFilter: Output<List<String>>?
        get() = javaResource.severitiesFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MicrosoftSecurityIncidentCreationAlertRuleMapper :
    ResourceMapper<MicrosoftSecurityIncidentCreationAlertRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule::class == javaResource::class

    override fun map(javaResource: Resource): MicrosoftSecurityIncidentCreationAlertRule =
        MicrosoftSecurityIncidentCreationAlertRule(
            javaResource as
                com.pulumi.azurenative.securityinsights.MicrosoftSecurityIncidentCreationAlertRule,
        )
}

/**
 * @see [MicrosoftSecurityIncidentCreationAlertRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MicrosoftSecurityIncidentCreationAlertRule].
 */
public suspend fun microsoftSecurityIncidentCreationAlertRule(
    name: String,
    block: suspend MicrosoftSecurityIncidentCreationAlertRuleResourceBuilder.() -> Unit,
):
    MicrosoftSecurityIncidentCreationAlertRule {
    val builder = MicrosoftSecurityIncidentCreationAlertRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MicrosoftSecurityIncidentCreationAlertRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun microsoftSecurityIncidentCreationAlertRule(name: String):
    MicrosoftSecurityIncidentCreationAlertRule {
    val builder = MicrosoftSecurityIncidentCreationAlertRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
