@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.OfficeDataConnectorDataTypesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securityinsights.kotlin.outputs.OfficeDataConnectorDataTypesResponse.Companion.toKotlin as officeDataConnectorDataTypesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [OfficeDataConnector].
 */
@PulumiTagMarker
public class OfficeDataConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OfficeDataConnectorArgs = OfficeDataConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OfficeDataConnectorArgsBuilder.() -> Unit) {
        val builder = OfficeDataConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OfficeDataConnector {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.OfficeDataConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OfficeDataConnector(builtJavaResource)
    }
}

/**
 * Represents office data connector.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates an Office365 data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var officeDataConnector = new AzureNative.SecurityInsights.OfficeDataConnector("officeDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         DataTypes = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesArgs
 *         {
 *             Exchange = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesExchangeArgs
 *             {
 *                 State = AzureNative.SecurityInsights.DataTypeState.Enabled,
 *             },
 *             SharePoint = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesSharePointArgs
 *             {
 *                 State = AzureNative.SecurityInsights.DataTypeState.Enabled,
 *             },
 *             Teams = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesTeamsArgs
 *             {
 *                 State = AzureNative.SecurityInsights.DataTypeState.Enabled,
 *             },
 *         },
 *         Kind = "Office365",
 *         ResourceGroupName = "myRg",
 *         TenantId = "2070ecc9-b4d5-4ae4-adaa-936fa1954fa8",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewOfficeDataConnector(ctx, "officeDataConnector", &securityinsights.OfficeDataConnectorArgs{
 * 			DataConnectorId: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			DataTypes: &securityinsights.OfficeDataConnectorDataTypesArgs{
 * 				Exchange: &securityinsights.OfficeDataConnectorDataTypesExchangeArgs{
 * 					State: pulumi.String(securityinsights.DataTypeStateEnabled),
 * 				},
 * 				SharePoint: &securityinsights.OfficeDataConnectorDataTypesSharePointArgs{
 * 					State: pulumi.String(securityinsights.DataTypeStateEnabled),
 * 				},
 * 				Teams: &securityinsights.OfficeDataConnectorDataTypesTeamsArgs{
 * 					State: pulumi.String(securityinsights.DataTypeStateEnabled),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("Office365"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			TenantId:          pulumi.String("2070ecc9-b4d5-4ae4-adaa-936fa1954fa8"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnector;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesExchangeArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesSharePointArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesTeamsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var officeDataConnector = new OfficeDataConnector("officeDataConnector", OfficeDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .dataTypes(OfficeDataConnectorDataTypesArgs.builder()
 *                 .exchange(OfficeDataConnectorDataTypesExchangeArgs.builder()
 *                     .state("Enabled")
 *                     .build())
 *                 .sharePoint(OfficeDataConnectorDataTypesSharePointArgs.builder()
 *                     .state("Enabled")
 *                     .build())
 *                 .teams(OfficeDataConnectorDataTypesTeamsArgs.builder()
 *                     .state("Enabled")
 *                     .build())
 *                 .build())
 *             .kind("Office365")
 *             .resourceGroupName("myRg")
 *             .tenantId("2070ecc9-b4d5-4ae4-adaa-936fa1954fa8")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an Threat Intelligence Platform data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var officeDataConnector = new AzureNative.SecurityInsights.OfficeDataConnector("officeDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewOfficeDataConnector(ctx, "officeDataConnector", &securityinsights.OfficeDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnector;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var officeDataConnector = new OfficeDataConnector("officeDataConnector", OfficeDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:OfficeDataConnector 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectors/{dataConnectorId}
 * ```
 */
public class OfficeDataConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.OfficeDataConnector,
) : KotlinCustomResource(javaResource, OfficeDataConnectorMapper) {
    /**
     * The available data types for the connector.
     */
    public val dataTypes: Output<OfficeDataConnectorDataTypesResponse>?
        get() = javaResource.dataTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    officeDataConnectorDataTypesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the data connector
     * Expected value is 'Office365'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tenant id to connect to, and get the data from.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OfficeDataConnectorMapper : ResourceMapper<OfficeDataConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.OfficeDataConnector::class == javaResource::class

    override fun map(javaResource: Resource): OfficeDataConnector = OfficeDataConnector(
        javaResource
            as com.pulumi.azurenative.securityinsights.OfficeDataConnector,
    )
}

/**
 * @see [OfficeDataConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OfficeDataConnector].
 */
public suspend fun officeDataConnector(
    name: String,
    block: suspend OfficeDataConnectorResourceBuilder.() -> Unit,
): OfficeDataConnector {
    val builder = OfficeDataConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OfficeDataConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun officeDataConnector(name: String): OfficeDataConnector {
    val builder = OfficeDataConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
