@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AlertSeverity
import com.pulumi.azurenative.securityinsights.kotlin.enums.AttackTactic
import com.pulumi.azurenative.securityinsights.kotlin.enums.TriggerOperator
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AlertDetailsOverrideArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AlertDetailsOverrideArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.EntityMappingArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.EntityMappingArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.EventGroupingSettingsArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.EventGroupingSettingsArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentConfigurationArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents scheduled alert rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates a Fusion alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledAlertRule = new AzureNative.SecurityInsights.ScheduledAlertRule("scheduledAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "myFirstFusionRule",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewScheduledAlertRule(ctx, "scheduledAlertRule", &securityinsights.ScheduledAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("myFirstFusionRule"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRule;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledAlertRule = new ScheduledAlertRule("scheduledAlertRule", ScheduledAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("myFirstFusionRule")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a MicrosoftSecurityIncidentCreation rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledAlertRule = new AzureNative.SecurityInsights.ScheduledAlertRule("scheduledAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "microsoftSecurityIncidentCreationRuleExample",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewScheduledAlertRule(ctx, "scheduledAlertRule", &securityinsights.ScheduledAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("microsoftSecurityIncidentCreationRuleExample"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRule;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledAlertRule = new ScheduledAlertRule("scheduledAlertRule", ScheduledAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("microsoftSecurityIncidentCreationRuleExample")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a Scheduled alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledAlertRule = new AzureNative.SecurityInsights.ScheduledAlertRule("scheduledAlertRule", new()
 *     {
 *         AlertDetailsOverride = new AzureNative.SecurityInsights.Inputs.AlertDetailsOverrideArgs
 *         {
 *             AlertDescriptionFormat = "Suspicious activity was made by {{ComputerIP}}",
 *             AlertDisplayNameFormat = "Alert from {{Computer}}",
 *             AlertDynamicProperties = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.AlertPropertyMappingArgs
 *                 {
 *                     AlertProperty = AzureNative.SecurityInsights.AlertProperty.ProductComponentName,
 *                     Value = "ProductComponentNameCustomColumn",
 *                 },
 *                 new AzureNative.SecurityInsights.Inputs.AlertPropertyMappingArgs
 *                 {
 *                     AlertProperty = AzureNative.SecurityInsights.AlertProperty.ProductName,
 *                     Value = "ProductNameCustomColumn",
 *                 },
 *                 new AzureNative.SecurityInsights.Inputs.AlertPropertyMappingArgs
 *                 {
 *                     AlertProperty = AzureNative.SecurityInsights.AlertProperty.AlertLink,
 *                     Value = "Link",
 *                 },
 *             },
 *         },
 *         CustomDetails =
 *         {
 *             { "OperatingSystemName", "OSName" },
 *             { "OperatingSystemType", "OSType" },
 *         },
 *         Description = "An example for a scheduled rule",
 *         DisplayName = "My scheduled rule",
 *         Enabled = true,
 *         EntityMappings = new[]
 *         {
 *             new AzureNative.SecurityInsights.Inputs.EntityMappingArgs
 *             {
 *                 EntityType = AzureNative.SecurityInsights.EntityMappingType.Host,
 *                 FieldMappings = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.FieldMappingArgs
 *                     {
 *                         ColumnName = "Computer",
 *                         Identifier = "FullName",
 *                     },
 *                 },
 *             },
 *             new AzureNative.SecurityInsights.Inputs.EntityMappingArgs
 *             {
 *                 EntityType = AzureNative.SecurityInsights.EntityMappingType.IP,
 *                 FieldMappings = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.FieldMappingArgs
 *                     {
 *                         ColumnName = "ComputerIP",
 *                         Identifier = "Address",
 *                     },
 *                 },
 *             },
 *         },
 *         EventGroupingSettings = new AzureNative.SecurityInsights.Inputs.EventGroupingSettingsArgs
 *         {
 *             AggregationKind = AzureNative.SecurityInsights.EventGroupingAggregationKind.AlertPerResult,
 *         },
 *         IncidentConfiguration = new AzureNative.SecurityInsights.Inputs.IncidentConfigurationArgs
 *         {
 *             CreateIncident = true,
 *             GroupingConfiguration = new AzureNative.SecurityInsights.Inputs.GroupingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 GroupByAlertDetails = new[]
 *                 {
 *                     AzureNative.SecurityInsights.AlertDetail.DisplayName,
 *                 },
 *                 GroupByCustomDetails = new[]
 *                 {
 *                     "OperatingSystemType",
 *                     "OperatingSystemName",
 *                 },
 *                 GroupByEntities = new[]
 *                 {
 *                     AzureNative.SecurityInsights.EntityMappingType.Host,
 *                 },
 *                 LookbackDuration = "PT5H",
 *                 MatchingMethod = AzureNative.SecurityInsights.MatchingMethod.Selected,
 *                 ReopenClosedIncident = false,
 *             },
 *         },
 *         Kind = "Scheduled",
 *         Query = "Heartbeat",
 *         QueryFrequency = "PT1H",
 *         QueryPeriod = "P2DT1H30M",
 *         ResourceGroupName = "myRg",
 *         RuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Severity = AzureNative.SecurityInsights.AlertSeverity.High,
 *         SuppressionDuration = "PT1H",
 *         SuppressionEnabled = false,
 *         Tactics = new[]
 *         {
 *             AzureNative.SecurityInsights.AttackTactic.Persistence,
 *             AzureNative.SecurityInsights.AttackTactic.LateralMovement,
 *         },
 *         TriggerOperator = AzureNative.SecurityInsights.TriggerOperator.GreaterThan,
 *         TriggerThreshold = 0,
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewScheduledAlertRule(ctx, "scheduledAlertRule", &securityinsights.ScheduledAlertRuleArgs{
 * 			AlertDetailsOverride: &securityinsights.AlertDetailsOverrideArgs{
 * 				AlertDescriptionFormat: pulumi.String("Suspicious activity was made by {{ComputerIP}}"),
 * 				AlertDisplayNameFormat: pulumi.String("Alert from {{Computer}}"),
 * 				AlertDynamicProperties: securityinsights.AlertPropertyMappingArray{
 * 					&securityinsights.AlertPropertyMappingArgs{
 * 						AlertProperty: pulumi.String(securityinsights.AlertPropertyProductComponentName),
 * 						Value:         pulumi.String("ProductComponentNameCustomColumn"),
 * 					},
 * 					&securityinsights.AlertPropertyMappingArgs{
 * 						AlertProperty: pulumi.String(securityinsights.AlertPropertyProductName),
 * 						Value:         pulumi.String("ProductNameCustomColumn"),
 * 					},
 * 					&securityinsights.AlertPropertyMappingArgs{
 * 						AlertProperty: pulumi.String(securityinsights.AlertPropertyAlertLink),
 * 						Value:         pulumi.String("Link"),
 * 					},
 * 				},
 * 			},
 * 			CustomDetails: pulumi.StringMap{
 * 				"OperatingSystemName": pulumi.String("OSName"),
 * 				"OperatingSystemType": pulumi.String("OSType"),
 * 			},
 * 			Description: pulumi.String("An example for a scheduled rule"),
 * 			DisplayName: pulumi.String("My scheduled rule"),
 * 			Enabled:     pulumi.Bool(true),
 * 			EntityMappings: securityinsights.EntityMappingArray{
 * 				&securityinsights.EntityMappingArgs{
 * 					EntityType: pulumi.String(securityinsights.EntityMappingTypeHost),
 * 					FieldMappings: securityinsights.FieldMappingArray{
 * 						&securityinsights.FieldMappingArgs{
 * 							ColumnName: pulumi.String("Computer"),
 * 							Identifier: pulumi.String("FullName"),
 * 						},
 * 					},
 * 				},
 * 				&securityinsights.EntityMappingArgs{
 * 					EntityType: pulumi.String(securityinsights.EntityMappingTypeIP),
 * 					FieldMappings: securityinsights.FieldMappingArray{
 * 						&securityinsights.FieldMappingArgs{
 * 							ColumnName: pulumi.String("ComputerIP"),
 * 							Identifier: pulumi.String("Address"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			EventGroupingSettings: &securityinsights.EventGroupingSettingsArgs{
 * 				AggregationKind: pulumi.String(securityinsights.EventGroupingAggregationKindAlertPerResult),
 * 			},
 * 			IncidentConfiguration: &securityinsights.IncidentConfigurationArgs{
 * 				CreateIncident: pulumi.Bool(true),
 * 				GroupingConfiguration: &securityinsights.GroupingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					GroupByAlertDetails: pulumi.StringArray{
 * 						pulumi.String(securityinsights.AlertDetailDisplayName),
 * 					},
 * 					GroupByCustomDetails: pulumi.StringArray{
 * 						pulumi.String("OperatingSystemType"),
 * 						pulumi.String("OperatingSystemName"),
 * 					},
 * 					GroupByEntities: pulumi.StringArray{
 * 						pulumi.String(securityinsights.EntityMappingTypeHost),
 * 					},
 * 					LookbackDuration:     pulumi.String("PT5H"),
 * 					MatchingMethod:       pulumi.String(securityinsights.MatchingMethodSelected),
 * 					ReopenClosedIncident: pulumi.Bool(false),
 * 				},
 * 			},
 * 			Kind:                pulumi.String("Scheduled"),
 * 			Query:               pulumi.String("Heartbeat"),
 * 			QueryFrequency:      pulumi.String("PT1H"),
 * 			QueryPeriod:         pulumi.String("P2DT1H30M"),
 * 			ResourceGroupName:   pulumi.String("myRg"),
 * 			RuleId:              pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			Severity:            pulumi.String(securityinsights.AlertSeverityHigh),
 * 			SuppressionDuration: pulumi.String("PT1H"),
 * 			SuppressionEnabled:  pulumi.Bool(false),
 * 			Tactics: pulumi.StringArray{
 * 				pulumi.String(securityinsights.AttackTacticPersistence),
 * 				pulumi.String(securityinsights.AttackTacticLateralMovement),
 * 			},
 * 			TriggerOperator:  securityinsights.TriggerOperatorGreaterThan,
 * 			TriggerThreshold: pulumi.Int(0),
 * 			WorkspaceName:    pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRule;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.AlertDetailsOverrideArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.EntityMappingArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.EventGroupingSettingsArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.IncidentConfigurationArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.GroupingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledAlertRule = new ScheduledAlertRule("scheduledAlertRule", ScheduledAlertRuleArgs.builder()
 *             .alertDetailsOverride(AlertDetailsOverrideArgs.builder()
 *                 .alertDescriptionFormat("Suspicious activity was made by {{ComputerIP}}")
 *                 .alertDisplayNameFormat("Alert from {{Computer}}")
 *                 .alertDynamicProperties(
 *                     AlertPropertyMappingArgs.builder()
 *                         .alertProperty("ProductComponentName")
 *                         .value("ProductComponentNameCustomColumn")
 *                         .build(),
 *                     AlertPropertyMappingArgs.builder()
 *                         .alertProperty("ProductName")
 *                         .value("ProductNameCustomColumn")
 *                         .build(),
 *                     AlertPropertyMappingArgs.builder()
 *                         .alertProperty("AlertLink")
 *                         .value("Link")
 *                         .build())
 *                 .build())
 *             .customDetails(Map.ofEntries(
 *                 Map.entry("OperatingSystemName", "OSName"),
 *                 Map.entry("OperatingSystemType", "OSType")
 *             ))
 *             .description("An example for a scheduled rule")
 *             .displayName("My scheduled rule")
 *             .enabled(true)
 *             .entityMappings(
 *                 EntityMappingArgs.builder()
 *                     .entityType("Host")
 *                     .fieldMappings(FieldMappingArgs.builder()
 *                         .columnName("Computer")
 *                         .identifier("FullName")
 *                         .build())
 *                     .build(),
 *                 EntityMappingArgs.builder()
 *                     .entityType("IP")
 *                     .fieldMappings(FieldMappingArgs.builder()
 *                         .columnName("ComputerIP")
 *                         .identifier("Address")
 *                         .build())
 *                     .build())
 *             .eventGroupingSettings(EventGroupingSettingsArgs.builder()
 *                 .aggregationKind("AlertPerResult")
 *                 .build())
 *             .incidentConfiguration(IncidentConfigurationArgs.builder()
 *                 .createIncident(true)
 *                 .groupingConfiguration(GroupingConfigurationArgs.builder()
 *                     .enabled(true)
 *                     .groupByAlertDetails("DisplayName")
 *                     .groupByCustomDetails(
 *                         "OperatingSystemType",
 *                         "OperatingSystemName")
 *                     .groupByEntities("Host")
 *                     .lookbackDuration("PT5H")
 *                     .matchingMethod("Selected")
 *                     .reopenClosedIncident(false)
 *                     .build())
 *                 .build())
 *             .kind("Scheduled")
 *             .query("Heartbeat")
 *             .queryFrequency("PT1H")
 *             .queryPeriod("P2DT1H30M")
 *             .resourceGroupName("myRg")
 *             .ruleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .severity("High")
 *             .suppressionDuration("PT1H")
 *             .suppressionEnabled(false)
 *             .tactics(
 *                 "Persistence",
 *                 "LateralMovement")
 *             .triggerOperator("GreaterThan")
 *             .triggerThreshold(0)
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ScheduledAlertRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/alertRules/{ruleId}
 * ```
 * @property alertDetailsOverride The alert details override settings
 * @property alertRuleTemplateName The Name of the alert rule template used to create this rule.
 * @property customDetails Dictionary of string key-value pairs of columns to be attached to the alert
 * @property description The description of the alert rule.
 * @property displayName The display name for alerts created by this alert rule.
 * @property enabled Determines whether this alert rule is enabled or disabled.
 * @property entityMappings Array of the entity mappings of the alert rule
 * @property eventGroupingSettings The event grouping settings.
 * @property incidentConfiguration The settings of the incidents that created from alerts triggered by this analytics rule
 * @property kind The kind of the alert rule
 * Expected value is 'Scheduled'.
 * @property query The query that creates alerts for this rule.
 * @property queryFrequency The frequency (in ISO 8601 duration format) for this alert rule to run.
 * @property queryPeriod The period (in ISO 8601 duration format) that this alert rule looks at.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId Alert rule ID
 * @property severity The severity for alerts created by this alert rule.
 * @property suppressionDuration The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
 * @property suppressionEnabled Determines whether the suppression for this alert rule is enabled or disabled.
 * @property tactics The tactics of the alert rule
 * @property techniques The techniques of the alert rule
 * @property templateVersion The version of the alert rule template used to create this rule - in format <a.b.c>, where all are numbers, for example 0 <1.0.2>
 * @property triggerOperator The operation against the threshold that triggers alert rule.
 * @property triggerThreshold The threshold triggers this alert rule.
 * @property workspaceName The name of the workspace.
 */
public data class ScheduledAlertRuleArgs(
    public val alertDetailsOverride: Output<AlertDetailsOverrideArgs>? = null,
    public val alertRuleTemplateName: Output<String>? = null,
    public val customDetails: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val entityMappings: Output<List<EntityMappingArgs>>? = null,
    public val eventGroupingSettings: Output<EventGroupingSettingsArgs>? = null,
    public val incidentConfiguration: Output<IncidentConfigurationArgs>? = null,
    public val kind: Output<String>? = null,
    public val query: Output<String>? = null,
    public val queryFrequency: Output<String>? = null,
    public val queryPeriod: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleId: Output<String>? = null,
    public val severity: Output<Either<String, AlertSeverity>>? = null,
    public val suppressionDuration: Output<String>? = null,
    public val suppressionEnabled: Output<Boolean>? = null,
    public val tactics: Output<List<Either<String, AttackTactic>>>? = null,
    public val techniques: Output<List<String>>? = null,
    public val templateVersion: Output<String>? = null,
    public val triggerOperator: Output<TriggerOperator>? = null,
    public val triggerThreshold: Output<Int>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs =
        com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs.builder()
            .alertDetailsOverride(
                alertDetailsOverride?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .alertRuleTemplateName(alertRuleTemplateName?.applyValue({ args0 -> args0 }))
            .customDetails(
                customDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .entityMappings(
                entityMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .eventGroupingSettings(
                eventGroupingSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .incidentConfiguration(
                incidentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .queryFrequency(queryFrequency?.applyValue({ args0 -> args0 }))
            .queryPeriod(queryPeriod?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .suppressionDuration(suppressionDuration?.applyValue({ args0 -> args0 }))
            .suppressionEnabled(suppressionEnabled?.applyValue({ args0 -> args0 }))
            .tactics(
                tactics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .techniques(techniques?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .templateVersion(templateVersion?.applyValue({ args0 -> args0 }))
            .triggerOperator(triggerOperator?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .triggerThreshold(triggerThreshold?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledAlertRuleArgs].
 */
@PulumiTagMarker
public class ScheduledAlertRuleArgsBuilder internal constructor() {
    private var alertDetailsOverride: Output<AlertDetailsOverrideArgs>? = null

    private var alertRuleTemplateName: Output<String>? = null

    private var customDetails: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var entityMappings: Output<List<EntityMappingArgs>>? = null

    private var eventGroupingSettings: Output<EventGroupingSettingsArgs>? = null

    private var incidentConfiguration: Output<IncidentConfigurationArgs>? = null

    private var kind: Output<String>? = null

    private var query: Output<String>? = null

    private var queryFrequency: Output<String>? = null

    private var queryPeriod: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleId: Output<String>? = null

    private var severity: Output<Either<String, AlertSeverity>>? = null

    private var suppressionDuration: Output<String>? = null

    private var suppressionEnabled: Output<Boolean>? = null

    private var tactics: Output<List<Either<String, AttackTactic>>>? = null

    private var techniques: Output<List<String>>? = null

    private var templateVersion: Output<String>? = null

    private var triggerOperator: Output<TriggerOperator>? = null

    private var triggerThreshold: Output<Int>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The alert details override settings
     */
    @JvmName("vrljeppbnnrqarcj")
    public suspend fun alertDetailsOverride(`value`: Output<AlertDetailsOverrideArgs>) {
        this.alertDetailsOverride = value
    }

    /**
     * @param value The Name of the alert rule template used to create this rule.
     */
    @JvmName("gsryhciyprwvvxxj")
    public suspend fun alertRuleTemplateName(`value`: Output<String>) {
        this.alertRuleTemplateName = value
    }

    /**
     * @param value Dictionary of string key-value pairs of columns to be attached to the alert
     */
    @JvmName("mvkeaecciqhkkuyj")
    public suspend fun customDetails(`value`: Output<Map<String, String>>) {
        this.customDetails = value
    }

    /**
     * @param value The description of the alert rule.
     */
    @JvmName("grhmgdvcbowrknnj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name for alerts created by this alert rule.
     */
    @JvmName("bsdknpyhtbfmygjm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Determines whether this alert rule is enabled or disabled.
     */
    @JvmName("gvsnhlejsxrdplng")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of the entity mappings of the alert rule
     */
    @JvmName("ckiqjpieianefyre")
    public suspend fun entityMappings(`value`: Output<List<EntityMappingArgs>>) {
        this.entityMappings = value
    }

    @JvmName("jkierjspcxjlubcp")
    public suspend fun entityMappings(vararg values: Output<EntityMappingArgs>) {
        this.entityMappings = Output.all(values.asList())
    }

    /**
     * @param values Array of the entity mappings of the alert rule
     */
    @JvmName("tnmoudkmsocmenja")
    public suspend fun entityMappings(values: List<Output<EntityMappingArgs>>) {
        this.entityMappings = Output.all(values)
    }

    /**
     * @param value The event grouping settings.
     */
    @JvmName("ggasvdqbeqyudvwi")
    public suspend fun eventGroupingSettings(`value`: Output<EventGroupingSettingsArgs>) {
        this.eventGroupingSettings = value
    }

    /**
     * @param value The settings of the incidents that created from alerts triggered by this analytics rule
     */
    @JvmName("tppouqkaegyqwthr")
    public suspend fun incidentConfiguration(`value`: Output<IncidentConfigurationArgs>) {
        this.incidentConfiguration = value
    }

    /**
     * @param value The kind of the alert rule
     * Expected value is 'Scheduled'.
     */
    @JvmName("sonfhemovitxymia")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The query that creates alerts for this rule.
     */
    @JvmName("edemqyloegmopgho")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The frequency (in ISO 8601 duration format) for this alert rule to run.
     */
    @JvmName("fpevvaggpcjkoljm")
    public suspend fun queryFrequency(`value`: Output<String>) {
        this.queryFrequency = value
    }

    /**
     * @param value The period (in ISO 8601 duration format) that this alert rule looks at.
     */
    @JvmName("vxoxhjapjevcbrrn")
    public suspend fun queryPeriod(`value`: Output<String>) {
        this.queryPeriod = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rmoroeypxcqwvvsc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("ychmppextuktsglg")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The severity for alerts created by this alert rule.
     */
    @JvmName("vdjewhiurxbqldup")
    public suspend fun severity(`value`: Output<Either<String, AlertSeverity>>) {
        this.severity = value
    }

    /**
     * @param value The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
     */
    @JvmName("xdkyhqwwketgmhob")
    public suspend fun suppressionDuration(`value`: Output<String>) {
        this.suppressionDuration = value
    }

    /**
     * @param value Determines whether the suppression for this alert rule is enabled or disabled.
     */
    @JvmName("aabwqoyoudujypkp")
    public suspend fun suppressionEnabled(`value`: Output<Boolean>) {
        this.suppressionEnabled = value
    }

    /**
     * @param value The tactics of the alert rule
     */
    @JvmName("pcjwufljitqycmjc")
    public suspend fun tactics(`value`: Output<List<Either<String, AttackTactic>>>) {
        this.tactics = value
    }

    @JvmName("cncwdrqxbrvhdchf")
    public suspend fun tactics(vararg values: Output<Either<String, AttackTactic>>) {
        this.tactics = Output.all(values.asList())
    }

    /**
     * @param values The tactics of the alert rule
     */
    @JvmName("iqxgqcfxdgkxhsnl")
    public suspend fun tactics(values: List<Output<Either<String, AttackTactic>>>) {
        this.tactics = Output.all(values)
    }

    /**
     * @param value The techniques of the alert rule
     */
    @JvmName("arqhlkxgddsisbob")
    public suspend fun techniques(`value`: Output<List<String>>) {
        this.techniques = value
    }

    @JvmName("ihghtjnnhtebbinc")
    public suspend fun techniques(vararg values: Output<String>) {
        this.techniques = Output.all(values.asList())
    }

    /**
     * @param values The techniques of the alert rule
     */
    @JvmName("lpivflklwgpntptk")
    public suspend fun techniques(values: List<Output<String>>) {
        this.techniques = Output.all(values)
    }

    /**
     * @param value The version of the alert rule template used to create this rule - in format <a.b.c>, where all are numbers, for example 0 <1.0.2>
     */
    @JvmName("genaokcajkgygauk")
    public suspend fun templateVersion(`value`: Output<String>) {
        this.templateVersion = value
    }

    /**
     * @param value The operation against the threshold that triggers alert rule.
     */
    @JvmName("hpexiagwxgakeeqd")
    public suspend fun triggerOperator(`value`: Output<TriggerOperator>) {
        this.triggerOperator = value
    }

    /**
     * @param value The threshold triggers this alert rule.
     */
    @JvmName("godjrhrxnwxwundb")
    public suspend fun triggerThreshold(`value`: Output<Int>) {
        this.triggerThreshold = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kopqolvxnrbbnxud")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The alert details override settings
     */
    @JvmName("nlbyjxivduyxhfyg")
    public suspend fun alertDetailsOverride(`value`: AlertDetailsOverrideArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertDetailsOverride = mapped
    }

    /**
     * @param argument The alert details override settings
     */
    @JvmName("bifywyqrlepxkpqc")
    public suspend
    fun alertDetailsOverride(argument: suspend AlertDetailsOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = AlertDetailsOverrideArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alertDetailsOverride = mapped
    }

    /**
     * @param value The Name of the alert rule template used to create this rule.
     */
    @JvmName("jytafnumfflxsqdb")
    public suspend fun alertRuleTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertRuleTemplateName = mapped
    }

    /**
     * @param value Dictionary of string key-value pairs of columns to be attached to the alert
     */
    @JvmName("wunuuphnfmyxldio")
    public suspend fun customDetails(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDetails = mapped
    }

    /**
     * @param values Dictionary of string key-value pairs of columns to be attached to the alert
     */
    @JvmName("ypejhbtwqcmetrdj")
    public fun customDetails(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDetails = mapped
    }

    /**
     * @param value The description of the alert rule.
     */
    @JvmName("hekffmkrqowubsva")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name for alerts created by this alert rule.
     */
    @JvmName("lqvvoctemprilwwk")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Determines whether this alert rule is enabled or disabled.
     */
    @JvmName("lcsvpsygtnorwceh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of the entity mappings of the alert rule
     */
    @JvmName("ypbdbrgogtwcrqrf")
    public suspend fun entityMappings(`value`: List<EntityMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityMappings = mapped
    }

    /**
     * @param argument Array of the entity mappings of the alert rule
     */
    @JvmName("hvcspjslfoayrldp")
    public suspend fun entityMappings(argument: List<suspend EntityMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EntityMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.entityMappings = mapped
    }

    /**
     * @param argument Array of the entity mappings of the alert rule
     */
    @JvmName("pygohrxpiwbitmsm")
    public suspend fun entityMappings(vararg argument: suspend EntityMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EntityMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.entityMappings = mapped
    }

    /**
     * @param argument Array of the entity mappings of the alert rule
     */
    @JvmName("unbbgqngeynufgdq")
    public suspend fun entityMappings(argument: suspend EntityMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EntityMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.entityMappings = mapped
    }

    /**
     * @param values Array of the entity mappings of the alert rule
     */
    @JvmName("jiuuatxmypamemdr")
    public suspend fun entityMappings(vararg values: EntityMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityMappings = mapped
    }

    /**
     * @param value The event grouping settings.
     */
    @JvmName("ncrrrwfiivoahgrc")
    public suspend fun eventGroupingSettings(`value`: EventGroupingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventGroupingSettings = mapped
    }

    /**
     * @param argument The event grouping settings.
     */
    @JvmName("ysaghdjccqmgyxow")
    public suspend
    fun eventGroupingSettings(argument: suspend EventGroupingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EventGroupingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventGroupingSettings = mapped
    }

    /**
     * @param value The settings of the incidents that created from alerts triggered by this analytics rule
     */
    @JvmName("wvssahguoxmhlebn")
    public suspend fun incidentConfiguration(`value`: IncidentConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentConfiguration = mapped
    }

    /**
     * @param argument The settings of the incidents that created from alerts triggered by this analytics rule
     */
    @JvmName("usekkhdqkcbmmjom")
    public suspend
    fun incidentConfiguration(argument: suspend IncidentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IncidentConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.incidentConfiguration = mapped
    }

    /**
     * @param value The kind of the alert rule
     * Expected value is 'Scheduled'.
     */
    @JvmName("nwhgnkmenkcmvswr")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The query that creates alerts for this rule.
     */
    @JvmName("fsacqxowpyaysmom")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The frequency (in ISO 8601 duration format) for this alert rule to run.
     */
    @JvmName("pcakmknqjavomtdu")
    public suspend fun queryFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryFrequency = mapped
    }

    /**
     * @param value The period (in ISO 8601 duration format) that this alert rule looks at.
     */
    @JvmName("kbsdjkmvtvishrei")
    public suspend fun queryPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryPeriod = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cbtsynleihawflkt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("vfvfawnridohqoqx")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The severity for alerts created by this alert rule.
     */
    @JvmName("ksrwoxvewkrkjmmk")
    public suspend fun severity(`value`: Either<String, AlertSeverity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity for alerts created by this alert rule.
     */
    @JvmName("hfrjthfeniyubgyw")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlertSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity for alerts created by this alert rule.
     */
    @JvmName("jjreamdmcrjgjlop")
    public fun severity(`value`: AlertSeverity) {
        val toBeMapped = Either.ofRight<String, AlertSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
     */
    @JvmName("wclcuqhxynmoqrek")
    public suspend fun suppressionDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressionDuration = mapped
    }

    /**
     * @param value Determines whether the suppression for this alert rule is enabled or disabled.
     */
    @JvmName("ffdmdjqopdrouiel")
    public suspend fun suppressionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressionEnabled = mapped
    }

    /**
     * @param value The tactics of the alert rule
     */
    @JvmName("wffusccdgqcdosew")
    public suspend fun tactics(`value`: List<Either<String, AttackTactic>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tactics = mapped
    }

    /**
     * @param values The tactics of the alert rule
     */
    @JvmName("lhedyqujxqyskcck")
    public suspend fun tactics(vararg values: Either<String, AttackTactic>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tactics = mapped
    }

    /**
     * @param value The techniques of the alert rule
     */
    @JvmName("ayouvspmfhvkiefp")
    public suspend fun techniques(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.techniques = mapped
    }

    /**
     * @param values The techniques of the alert rule
     */
    @JvmName("jmcrowmgcqbqrfnw")
    public suspend fun techniques(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.techniques = mapped
    }

    /**
     * @param value The version of the alert rule template used to create this rule - in format <a.b.c>, where all are numbers, for example 0 <1.0.2>
     */
    @JvmName("rfttbelhspjuabxd")
    public suspend fun templateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateVersion = mapped
    }

    /**
     * @param value The operation against the threshold that triggers alert rule.
     */
    @JvmName("wacyygndbwqouqbp")
    public suspend fun triggerOperator(`value`: TriggerOperator?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerOperator = mapped
    }

    /**
     * @param value The threshold triggers this alert rule.
     */
    @JvmName("vbshmnaqancgvvyt")
    public suspend fun triggerThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerThreshold = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fmvhcmtsxpnolutm")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ScheduledAlertRuleArgs = ScheduledAlertRuleArgs(
        alertDetailsOverride = alertDetailsOverride,
        alertRuleTemplateName = alertRuleTemplateName,
        customDetails = customDetails,
        description = description,
        displayName = displayName,
        enabled = enabled,
        entityMappings = entityMappings,
        eventGroupingSettings = eventGroupingSettings,
        incidentConfiguration = incidentConfiguration,
        kind = kind,
        query = query,
        queryFrequency = queryFrequency,
        queryPeriod = queryPeriod,
        resourceGroupName = resourceGroupName,
        ruleId = ruleId,
        severity = severity,
        suppressionDuration = suppressionDuration,
        suppressionEnabled = suppressionEnabled,
        tactics = tactics,
        techniques = techniques,
        templateVersion = templateVersion,
        triggerOperator = triggerOperator,
        triggerThreshold = triggerThreshold,
        workspaceName = workspaceName,
    )
}
