@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.TIDataConnectorArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.TIDataConnectorDataTypesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.TIDataConnectorDataTypesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents threat intelligence data connector.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates an Office365 data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tiDataConnector = new AzureNative.SecurityInsights.TIDataConnector("tiDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewTIDataConnector(ctx, "tiDataConnector", &securityinsights.TIDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.TIDataConnector;
 * import com.pulumi.azurenative.securityinsights.TIDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tiDataConnector = new TIDataConnector("tiDataConnector", TIDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an Threat Intelligence Platform data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tiDataConnector = new AzureNative.SecurityInsights.TIDataConnector("tiDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         DataTypes = new AzureNative.SecurityInsights.Inputs.TIDataConnectorDataTypesArgs
 *         {
 *             Indicators = new AzureNative.SecurityInsights.Inputs.TIDataConnectorDataTypesIndicatorsArgs
 *             {
 *                 State = AzureNative.SecurityInsights.DataTypeState.Enabled,
 *             },
 *         },
 *         Kind = "ThreatIntelligence",
 *         ResourceGroupName = "myRg",
 *         TenantId = "06b3ccb8-1384-4bcc-aec7-852f6d57161b",
 *         TipLookbackPeriod = "2020-01-01T13:00:30.123Z",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewTIDataConnector(ctx, "tiDataConnector", &securityinsights.TIDataConnectorArgs{
 * 			DataConnectorId: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			DataTypes: &securityinsights.TIDataConnectorDataTypesArgs{
 * 				Indicators: &securityinsights.TIDataConnectorDataTypesIndicatorsArgs{
 * 					State: pulumi.String(securityinsights.DataTypeStateEnabled),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("ThreatIntelligence"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			TenantId:          pulumi.String("06b3ccb8-1384-4bcc-aec7-852f6d57161b"),
 * 			TipLookbackPeriod: pulumi.String("2020-01-01T13:00:30.123Z"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.TIDataConnector;
 * import com.pulumi.azurenative.securityinsights.TIDataConnectorArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesIndicatorsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tiDataConnector = new TIDataConnector("tiDataConnector", TIDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .dataTypes(TIDataConnectorDataTypesArgs.builder()
 *                 .indicators(TIDataConnectorDataTypesIndicatorsArgs.builder()
 *                     .state("Enabled")
 *                     .build())
 *                 .build())
 *             .kind("ThreatIntelligence")
 *             .resourceGroupName("myRg")
 *             .tenantId("06b3ccb8-1384-4bcc-aec7-852f6d57161b")
 *             .tipLookbackPeriod("2020-01-01T13:00:30.123Z")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:TIDataConnector 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectors/{dataConnectorId}
 * ```
 * @property dataConnectorId Connector ID
 * @property dataTypes The available data types for the connector.
 * @property kind The kind of the data connector
 * Expected value is 'ThreatIntelligence'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tenantId The tenant id to connect to, and get the data from.
 * @property tipLookbackPeriod The lookback period for the feed to be imported.
 * @property workspaceName The name of the workspace.
 */
public data class TIDataConnectorArgs(
    public val dataConnectorId: Output<String>? = null,
    public val dataTypes: Output<TIDataConnectorDataTypesArgs>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val tipLookbackPeriod: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.TIDataConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.TIDataConnectorArgs =
        com.pulumi.azurenative.securityinsights.TIDataConnectorArgs.builder()
            .dataConnectorId(dataConnectorId?.applyValue({ args0 -> args0 }))
            .dataTypes(dataTypes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .tipLookbackPeriod(tipLookbackPeriod?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TIDataConnectorArgs].
 */
@PulumiTagMarker
public class TIDataConnectorArgsBuilder internal constructor() {
    private var dataConnectorId: Output<String>? = null

    private var dataTypes: Output<TIDataConnectorDataTypesArgs>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var tipLookbackPeriod: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Connector ID
     */
    @JvmName("wbpewvmnfaacbxwr")
    public suspend fun dataConnectorId(`value`: Output<String>) {
        this.dataConnectorId = value
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("fklqptxvhrkdhaxk")
    public suspend fun dataTypes(`value`: Output<TIDataConnectorDataTypesArgs>) {
        this.dataTypes = value
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'ThreatIntelligence'.
     */
    @JvmName("vmxujgrduftelfuo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ubqnmcwoonekxvtw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tenant id to connect to, and get the data from.
     */
    @JvmName("puhpnahghlatwrul")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The lookback period for the feed to be imported.
     */
    @JvmName("uidaaopjyjtylkcf")
    public suspend fun tipLookbackPeriod(`value`: Output<String>) {
        this.tipLookbackPeriod = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("rodbnqoywfjhielt")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Connector ID
     */
    @JvmName("desvasmodrfmnnta")
    public suspend fun dataConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectorId = mapped
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("ogxmnrxgbipjfkre")
    public suspend fun dataTypes(`value`: TIDataConnectorDataTypesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param argument The available data types for the connector.
     */
    @JvmName("oxcgcfueltvkyaca")
    public suspend fun dataTypes(argument: suspend TIDataConnectorDataTypesArgsBuilder.() -> Unit) {
        val toBeMapped = TIDataConnectorDataTypesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataTypes = mapped
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'ThreatIntelligence'.
     */
    @JvmName("xoraeaxpuwdqviqp")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("liuxiwrohvhlxahn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tenant id to connect to, and get the data from.
     */
    @JvmName("sxpupsvxwcqtkpro")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The lookback period for the feed to be imported.
     */
    @JvmName("sqaoepwljmusgrck")
    public suspend fun tipLookbackPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tipLookbackPeriod = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ararnjjpmldmhnek")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): TIDataConnectorArgs = TIDataConnectorArgs(
        dataConnectorId = dataConnectorId,
        dataTypes = dataTypes,
        kind = kind,
        resourceGroupName = resourceGroupName,
        tenantId = tenantId,
        tipLookbackPeriod = tipLookbackPeriod,
        workspaceName = workspaceName,
    )
}
