@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse.Companion.toKotlin as watchlistUserInfoResponseToKotlin

/**
 * Builder for [Watchlist].
 */
@PulumiTagMarker
public class WatchlistResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WatchlistArgs = WatchlistArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WatchlistArgsBuilder.() -> Unit) {
        val builder = WatchlistArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Watchlist {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.Watchlist(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Watchlist(builtJavaResource)
    }
}

/**
 * Represents a Watchlist in Azure Security Insights.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2019-01-01-preview, 2021-03-01-preview, 2021-04-01, 2021-10-01-preview, 2022-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### Create or update a watchlist and bulk creates watchlist items.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watchlist = new AzureNative.SecurityInsights.Watchlist("watchlist", new()
 *     {
 *         ContentType = "text/csv",
 *         Description = "Watchlist from CSV content",
 *         DisplayName = "High Value Assets Watchlist",
 *         ItemsSearchKey = "header1",
 *         NumberOfLinesToSkip = 1,
 *         Provider = "Microsoft",
 *         RawContent = @"This line will be skipped
 * header1,header2
 * value1,value2",
 *         ResourceGroupName = "myRg",
 *         Source = AzureNative.SecurityInsights.Source.Local_file,
 *         WatchlistAlias = "highValueAsset",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWatchlist(ctx, "watchlist", &securityinsights.WatchlistArgs{
 * 			ContentType:         pulumi.String("text/csv"),
 * 			Description:         pulumi.String("Watchlist from CSV content"),
 * 			DisplayName:         pulumi.String("High Value Assets Watchlist"),
 * 			ItemsSearchKey:      pulumi.String("header1"),
 * 			NumberOfLinesToSkip: pulumi.Int(1),
 * 			Provider:            pulumi.String("Microsoft"),
 * 			RawContent:          pulumi.String("This line will be skipped\nheader1,header2\nvalue1,value2"),
 * 			ResourceGroupName:   pulumi.String("myRg"),
 * 			Source:              pulumi.String(securityinsights.Source_Local_file),
 * 			WatchlistAlias:      pulumi.String("highValueAsset"),
 * 			WorkspaceName:       pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Watchlist;
 * import com.pulumi.azurenative.securityinsights.WatchlistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watchlist = new Watchlist("watchlist", WatchlistArgs.builder()
 *             .contentType("text/csv")
 *             .description("Watchlist from CSV content")
 *             .displayName("High Value Assets Watchlist")
 *             .itemsSearchKey("header1")
 *             .numberOfLinesToSkip(1)
 *             .provider("Microsoft")
 *             .rawContent("""
 * This line will be skipped
 * header1,header2
 * value1,value2            """)
 *             .resourceGroupName("myRg")
 *             .source("Local file")
 *             .watchlistAlias("highValueAsset")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a watchlist.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watchlist = new AzureNative.SecurityInsights.Watchlist("watchlist", new()
 *     {
 *         Description = "Watchlist from CSV content",
 *         DisplayName = "High Value Assets Watchlist",
 *         ItemsSearchKey = "header1",
 *         Provider = "Microsoft",
 *         ResourceGroupName = "myRg",
 *         Source = AzureNative.SecurityInsights.Source.Local_file,
 *         WatchlistAlias = "highValueAsset",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWatchlist(ctx, "watchlist", &securityinsights.WatchlistArgs{
 * 			Description:       pulumi.String("Watchlist from CSV content"),
 * 			DisplayName:       pulumi.String("High Value Assets Watchlist"),
 * 			ItemsSearchKey:    pulumi.String("header1"),
 * 			Provider:          pulumi.String("Microsoft"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Source:            pulumi.String(securityinsights.Source_Local_file),
 * 			WatchlistAlias:    pulumi.String("highValueAsset"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Watchlist;
 * import com.pulumi.azurenative.securityinsights.WatchlistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watchlist = new Watchlist("watchlist", WatchlistArgs.builder()
 *             .description("Watchlist from CSV content")
 *             .displayName("High Value Assets Watchlist")
 *             .itemsSearchKey("header1")
 *             .provider("Microsoft")
 *             .resourceGroupName("myRg")
 *             .source("Local file")
 *             .watchlistAlias("highValueAsset")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Watchlist highValueAsset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/watchlists/{watchlistAlias}
 * ```
 */
public class Watchlist internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.Watchlist,
) : KotlinCustomResource(javaResource, WatchlistMapper) {
    /**
     * The content type of the raw content. For now, only text/csv is valid
     */
    public val contentType: Output<String>?
        get() = javaResource.contentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time the watchlist was created
     */
    public val created: Output<String>?
        get() = javaResource.created().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes a user that created the watchlist
     */
    public val createdBy: Output<WatchlistUserInfoResponse>?
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    watchlistUserInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The default duration of a watchlist (in ISO 8601 duration format)
     */
    public val defaultDuration: Output<String>?
        get() = javaResource.defaultDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A description of the watchlist
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the watchlist
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A flag that indicates if the watchlist is deleted or not
     */
    public val isDeleted: Output<Boolean>?
        get() = javaResource.isDeleted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The search key is used to optimize query performance when using watchlists for joins with other data. For example, enable a column with IP addresses to be the designated SearchKey field, then use this field as the key field when joining to other event data by IP address.
     */
    public val itemsSearchKey: Output<String>
        get() = javaResource.itemsSearchKey().applyValue({ args0 -> args0 })

    /**
     * List of labels relevant to this watchlist
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of lines in a csv content to skip before the header
     */
    public val numberOfLinesToSkip: Output<Int>?
        get() = javaResource.numberOfLinesToSkip().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provider of the watchlist
     */
    public val provider: Output<String>
        get() = javaResource.provider().applyValue({ args0 -> args0 })

    /**
     * The raw content that represents to watchlist items to create. Example : This line will be skipped
     * header1,header2
     * value1,value2
     */
    public val rawContent: Output<String>?
        get() = javaResource.rawContent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source of the watchlist
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tenantId where the watchlist belongs to
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The last time the watchlist was updated
     */
    public val updated: Output<String>?
        get() = javaResource.updated().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes a user that updated the watchlist
     */
    public val updatedBy: Output<WatchlistUserInfoResponse>?
        get() = javaResource.updatedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    watchlistUserInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The status of the Watchlist upload : New, InProgress or Complete. **Note** : When a Watchlist upload status is InProgress, the Watchlist cannot be deleted
     */
    public val uploadStatus: Output<String>?
        get() = javaResource.uploadStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The alias of the watchlist
     */
    public val watchlistAlias: Output<String>?
        get() = javaResource.watchlistAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id (a Guid) of the watchlist
     */
    public val watchlistId: Output<String>?
        get() = javaResource.watchlistId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the watchlist
     */
    public val watchlistType: Output<String>?
        get() = javaResource.watchlistType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object WatchlistMapper : ResourceMapper<Watchlist> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.Watchlist::class == javaResource::class

    override fun map(javaResource: Resource): Watchlist = Watchlist(
        javaResource as
            com.pulumi.azurenative.securityinsights.Watchlist,
    )
}

/**
 * @see [Watchlist].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Watchlist].
 */
public suspend fun watchlist(name: String, block: suspend WatchlistResourceBuilder.() -> Unit):
    Watchlist {
    val builder = WatchlistResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Watchlist].
 * @param name The _unique_ name of the resulting resource.
 */
public fun watchlist(name: String): Watchlist {
    val builder = WatchlistResourceBuilder()
    builder.name(name)
    return builder.build()
}
