@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.WorkspaceManagerConfigurationArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.Mode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The workspace manager configuration
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Create or Update a workspace manager Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerConfiguration = new AzureNative.SecurityInsights.WorkspaceManagerConfiguration("workspaceManagerConfiguration", new()
 *     {
 *         Mode = AzureNative.SecurityInsights.Mode.Enabled,
 *         ResourceGroupName = "myRg",
 *         WorkspaceManagerConfigurationName = "default",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerConfiguration(ctx, "workspaceManagerConfiguration", &securityinsights.WorkspaceManagerConfigurationArgs{
 * 			Mode:                              pulumi.String(securityinsights.ModeEnabled),
 * 			ResourceGroupName:                 pulumi.String("myRg"),
 * 			WorkspaceManagerConfigurationName: pulumi.String("default"),
 * 			WorkspaceName:                     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerConfiguration;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerConfiguration = new WorkspaceManagerConfiguration("workspaceManagerConfiguration", WorkspaceManagerConfigurationArgs.builder()
 *             .mode("Enabled")
 *             .resourceGroupName("myRg")
 *             .workspaceManagerConfigurationName("default")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerConfigurations/{workspaceManagerConfigurationName}
 * ```
 * @property mode The current mode of the workspace manager configuration
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceManagerConfigurationName The name of the workspace manager configuration
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceManagerConfigurationArgs(
    public val mode: Output<Either<String, Mode>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceManagerConfigurationName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.WorkspaceManagerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.WorkspaceManagerConfigurationArgs =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerConfigurationArgs.builder()
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceManagerConfigurationName(
                workspaceManagerConfigurationName?.applyValue({ args0 ->
                    args0
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceManagerConfigurationArgs].
 */
@PulumiTagMarker
public class WorkspaceManagerConfigurationArgsBuilder internal constructor() {
    private var mode: Output<Either<String, Mode>>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceManagerConfigurationName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The current mode of the workspace manager configuration
     */
    @JvmName("wbhoitoiifkgvtig")
    public suspend fun mode(`value`: Output<Either<String, Mode>>) {
        this.mode = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bvxplggbxwvaoirc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace manager configuration
     */
    @JvmName("vvvbijfxnouxadcf")
    public suspend fun workspaceManagerConfigurationName(`value`: Output<String>) {
        this.workspaceManagerConfigurationName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mylukfrjndpjhnqp")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The current mode of the workspace manager configuration
     */
    @JvmName("lixetdfpogcvcllx")
    public suspend fun mode(`value`: Either<String, Mode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The current mode of the workspace manager configuration
     */
    @JvmName("wajqkrlbvrvkanon")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The current mode of the workspace manager configuration
     */
    @JvmName("jnqpunlwlsyxoqwy")
    public fun mode(`value`: Mode) {
        val toBeMapped = Either.ofRight<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("slgncydxvsifuqty")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace manager configuration
     */
    @JvmName("gcykcordktjultey")
    public suspend fun workspaceManagerConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceManagerConfigurationName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("efessshhpwpemgld")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceManagerConfigurationArgs = WorkspaceManagerConfigurationArgs(
        mode = mode,
        resourceGroupName = resourceGroupName,
        workspaceManagerConfigurationName = workspaceManagerConfigurationName,
        workspaceName = workspaceName,
    )
}
