@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.WorkspaceManagerGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The workspace manager group
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a workspace manager group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerGroup = new AzureNative.SecurityInsights.WorkspaceManagerGroup("workspaceManagerGroup", new()
 *     {
 *         Description = "Group of all financial and banking institutions",
 *         DisplayName = "Banks",
 *         MemberResourceNames = new[]
 *         {
 *             "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *             "f5fa104e-c0e3-4747-9182-d342dc048a9e",
 *         },
 *         ResourceGroupName = "myRg",
 *         WorkspaceManagerGroupName = "37207a7a-3b8a-438f-a559-c7df400e1b96",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerGroup(ctx, "workspaceManagerGroup", &securityinsights.WorkspaceManagerGroupArgs{
 * 			Description: pulumi.String("Group of all financial and banking institutions"),
 * 			DisplayName: pulumi.String("Banks"),
 * 			MemberResourceNames: pulumi.StringArray{
 * 				pulumi.String("afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 				pulumi.String("f5fa104e-c0e3-4747-9182-d342dc048a9e"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("myRg"),
 * 			WorkspaceManagerGroupName: pulumi.String("37207a7a-3b8a-438f-a559-c7df400e1b96"),
 * 			WorkspaceName:             pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerGroup;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerGroup = new WorkspaceManagerGroup("workspaceManagerGroup", WorkspaceManagerGroupArgs.builder()
 *             .description("Group of all financial and banking institutions")
 *             .displayName("Banks")
 *             .memberResourceNames(
 *                 "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *                 "f5fa104e-c0e3-4747-9182-d342dc048a9e")
 *             .resourceGroupName("myRg")
 *             .workspaceManagerGroupName("37207a7a-3b8a-438f-a559-c7df400e1b96")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerGroup 37207a7a-3b8a-438f-a559-c7df400e1b96 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}
 * ```
 * @property description The description of the workspace manager group
 * @property displayName The display name of the workspace manager group
 * @property memberResourceNames The names of the workspace manager members participating in this group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceManagerGroupName The name of the workspace manager group
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceManagerGroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val memberResourceNames: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceManagerGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.WorkspaceManagerGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.WorkspaceManagerGroupArgs =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .memberResourceNames(memberResourceNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceManagerGroupName(workspaceManagerGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceManagerGroupArgs].
 */
@PulumiTagMarker
public class WorkspaceManagerGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var memberResourceNames: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceManagerGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The description of the workspace manager group
     */
    @JvmName("qnpmyiumaqgkpjuk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the workspace manager group
     */
    @JvmName("wyksspdboahitapy")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The names of the workspace manager members participating in this group.
     */
    @JvmName("cvlvhjlvnsouvcob")
    public suspend fun memberResourceNames(`value`: Output<List<String>>) {
        this.memberResourceNames = value
    }

    @JvmName("eknuwpynyuuutnbg")
    public suspend fun memberResourceNames(vararg values: Output<String>) {
        this.memberResourceNames = Output.all(values.asList())
    }

    /**
     * @param values The names of the workspace manager members participating in this group.
     */
    @JvmName("mqyylpecrlcecnpg")
    public suspend fun memberResourceNames(values: List<Output<String>>) {
        this.memberResourceNames = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uwyscxgvjqmfhdth")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace manager group
     */
    @JvmName("wkqhmqkvwwxeufuy")
    public suspend fun workspaceManagerGroupName(`value`: Output<String>) {
        this.workspaceManagerGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iybkiodijssbltym")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The description of the workspace manager group
     */
    @JvmName("fvvnboddipyeqtat")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the workspace manager group
     */
    @JvmName("dkartysdcgcotsfa")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The names of the workspace manager members participating in this group.
     */
    @JvmName("cegcsxhjcexwjjbq")
    public suspend fun memberResourceNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberResourceNames = mapped
    }

    /**
     * @param values The names of the workspace manager members participating in this group.
     */
    @JvmName("qvfbrwiretoydgga")
    public suspend fun memberResourceNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberResourceNames = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("biosxtrwosxueygr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace manager group
     */
    @JvmName("mlcgvcbfndwkyqro")
    public suspend fun workspaceManagerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceManagerGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("clfwpaibawxemyew")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceManagerGroupArgs = WorkspaceManagerGroupArgs(
        description = description,
        displayName = displayName,
        memberResourceNames = memberResourceNames,
        resourceGroupName = resourceGroupName,
        workspaceManagerGroupName = workspaceManagerGroupName,
        workspaceName = workspaceName,
    )
}
