@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.WorkspaceManagerMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The workspace manager member
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Create or Update a workspace manager member
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerMember = new AzureNative.SecurityInsights.WorkspaceManagerMember("workspaceManagerMember", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         TargetWorkspaceResourceId = "/subscriptions/7aef9d48-814f-45ad-b644-b0343316e174/resourceGroups/otherRg/providers/Microsoft.OperationalInsights/workspaces/Example_Workspace",
 *         TargetWorkspaceTenantId = "f676d436-8d16-42db-81b7-ab578e110ccd",
 *         WorkspaceManagerMemberName = "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerMember(ctx, "workspaceManagerMember", &securityinsights.WorkspaceManagerMemberArgs{
 * 			ResourceGroupName:          pulumi.String("myRg"),
 * 			TargetWorkspaceResourceId:  pulumi.String("/subscriptions/7aef9d48-814f-45ad-b644-b0343316e174/resourceGroups/otherRg/providers/Microsoft.OperationalInsights/workspaces/Example_Workspace"),
 * 			TargetWorkspaceTenantId:    pulumi.String("f676d436-8d16-42db-81b7-ab578e110ccd"),
 * 			WorkspaceManagerMemberName: pulumi.String("afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 			WorkspaceName:              pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerMember;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerMember = new WorkspaceManagerMember("workspaceManagerMember", WorkspaceManagerMemberArgs.builder()
 *             .resourceGroupName("myRg")
 *             .targetWorkspaceResourceId("/subscriptions/7aef9d48-814f-45ad-b644-b0343316e174/resourceGroups/otherRg/providers/Microsoft.OperationalInsights/workspaces/Example_Workspace")
 *             .targetWorkspaceTenantId("f676d436-8d16-42db-81b7-ab578e110ccd")
 *             .workspaceManagerMemberName("afbd324f-6c48-459c-8710-8d1e1cd03812")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerMember afbd324f-6c48-459c-8710-8d1e1cd03812 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}
 * ```
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property targetWorkspaceResourceId Fully qualified resource ID of the target Sentinel workspace joining the given Sentinel workspace manager
 * @property targetWorkspaceTenantId Tenant id of the target Sentinel workspace joining the given Sentinel workspace manager
 * @property workspaceManagerMemberName The name of the workspace manager member
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceManagerMemberArgs(
    public val resourceGroupName: Output<String>? = null,
    public val targetWorkspaceResourceId: Output<String>? = null,
    public val targetWorkspaceTenantId: Output<String>? = null,
    public val workspaceManagerMemberName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.WorkspaceManagerMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.WorkspaceManagerMemberArgs =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerMemberArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .targetWorkspaceResourceId(targetWorkspaceResourceId?.applyValue({ args0 -> args0 }))
            .targetWorkspaceTenantId(targetWorkspaceTenantId?.applyValue({ args0 -> args0 }))
            .workspaceManagerMemberName(workspaceManagerMemberName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceManagerMemberArgs].
 */
@PulumiTagMarker
public class WorkspaceManagerMemberArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var targetWorkspaceResourceId: Output<String>? = null

    private var targetWorkspaceTenantId: Output<String>? = null

    private var workspaceManagerMemberName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bpglgthlanmcigum")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Fully qualified resource ID of the target Sentinel workspace joining the given Sentinel workspace manager
     */
    @JvmName("fkdawyaxoxmblrlx")
    public suspend fun targetWorkspaceResourceId(`value`: Output<String>) {
        this.targetWorkspaceResourceId = value
    }

    /**
     * @param value Tenant id of the target Sentinel workspace joining the given Sentinel workspace manager
     */
    @JvmName("dwdyyqsgswfitfkg")
    public suspend fun targetWorkspaceTenantId(`value`: Output<String>) {
        this.targetWorkspaceTenantId = value
    }

    /**
     * @param value The name of the workspace manager member
     */
    @JvmName("fnawdlbqtcxmuejn")
    public suspend fun workspaceManagerMemberName(`value`: Output<String>) {
        this.workspaceManagerMemberName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("arbdafjxpasrqxrk")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eripbvaxncxticvn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Fully qualified resource ID of the target Sentinel workspace joining the given Sentinel workspace manager
     */
    @JvmName("bqryttygvwbxbykp")
    public suspend fun targetWorkspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetWorkspaceResourceId = mapped
    }

    /**
     * @param value Tenant id of the target Sentinel workspace joining the given Sentinel workspace manager
     */
    @JvmName("ylnsssbomhtyyyov")
    public suspend fun targetWorkspaceTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetWorkspaceTenantId = mapped
    }

    /**
     * @param value The name of the workspace manager member
     */
    @JvmName("jsivtgqyopdvrwrv")
    public suspend fun workspaceManagerMemberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceManagerMemberName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("cioypnnovgigunky")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceManagerMemberArgs = WorkspaceManagerMemberArgs(
        resourceGroupName = resourceGroupName,
        targetWorkspaceResourceId = targetWorkspaceResourceId,
        targetWorkspaceTenantId = targetWorkspaceTenantId,
        workspaceManagerMemberName = workspaceManagerMemberName,
        workspaceName = workspaceName,
    )
}
