@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The severity for alerts created by this alert rule.
 */
public enum class AttackTactic(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.AttackTactic,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.AttackTactic> {
    Reconnaissance(com.pulumi.azurenative.securityinsights.enums.AttackTactic.Reconnaissance),
    ResourceDevelopment(com.pulumi.azurenative.securityinsights.enums.AttackTactic.ResourceDevelopment),
    InitialAccess(com.pulumi.azurenative.securityinsights.enums.AttackTactic.InitialAccess),
    Execution(com.pulumi.azurenative.securityinsights.enums.AttackTactic.Execution),
    Persistence(com.pulumi.azurenative.securityinsights.enums.AttackTactic.Persistence),
    PrivilegeEscalation(com.pulumi.azurenative.securityinsights.enums.AttackTactic.PrivilegeEscalation),
    DefenseEvasion(com.pulumi.azurenative.securityinsights.enums.AttackTactic.DefenseEvasion),
    CredentialAccess(com.pulumi.azurenative.securityinsights.enums.AttackTactic.CredentialAccess),
    Discovery(com.pulumi.azurenative.securityinsights.enums.AttackTactic.Discovery),
    LateralMovement(com.pulumi.azurenative.securityinsights.enums.AttackTactic.LateralMovement),
    Collection(com.pulumi.azurenative.securityinsights.enums.AttackTactic.Collection),
    Exfiltration(com.pulumi.azurenative.securityinsights.enums.AttackTactic.Exfiltration),
    CommandAndControl(com.pulumi.azurenative.securityinsights.enums.AttackTactic.CommandAndControl),
    Impact(com.pulumi.azurenative.securityinsights.enums.AttackTactic.Impact),
    PreAttack(com.pulumi.azurenative.securityinsights.enums.AttackTactic.PreAttack),
    ImpairProcessControl(com.pulumi.azurenative.securityinsights.enums.AttackTactic.ImpairProcessControl),
    InhibitResponseFunction(com.pulumi.azurenative.securityinsights.enums.AttackTactic.InhibitResponseFunction),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.AttackTactic = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.AttackTactic):
            AttackTactic = AttackTactic.values().first { it.javaValue == javaType }
    }
}
