@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the owner the incident is assigned to.
 */
public enum class OwnerType(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.OwnerType,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.OwnerType> {
    /**
     * The incident owner type is unknown
     */
    Unknown(com.pulumi.azurenative.securityinsights.enums.OwnerType.Unknown),

    /**
     * The incident owner type is an AAD user
     */
    User(com.pulumi.azurenative.securityinsights.enums.OwnerType.User),

    /**
     * The incident owner type is an AAD group
     */
    Group(com.pulumi.azurenative.securityinsights.enums.OwnerType.Group),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.OwnerType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.OwnerType):
            OwnerType = OwnerType.values().first { it.javaValue == javaType }
    }
}
