@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AssignmentItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An entity describing a content item.
 * @property resourceId The resource id of the content item
 */
public data class AssignmentItemArgs(
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AssignmentItemArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.AssignmentItemArgs =
        com.pulumi.azurenative.securityinsights.inputs.AssignmentItemArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignmentItemArgs].
 */
@PulumiTagMarker
public class AssignmentItemArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value The resource id of the content item
     */
    @JvmName("hmyohavtyjthestp")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The resource id of the content item
     */
    @JvmName("adgbofvwepoimodp")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): AssignmentItemArgs = AssignmentItemArgs(
        resourceId = resourceId,
    )
}
