@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AutomationRuleModifyPropertiesActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an automation rule action to modify an object's properties
 * @property actionConfiguration
 * @property actionType The type of the automation rule action.
 * Expected value is 'ModifyProperties'.
 * @property order
 */
public data class AutomationRuleModifyPropertiesActionArgs(
    public val actionConfiguration: Output<IncidentPropertiesActionArgs>? = null,
    public val actionType: Output<String>,
    public val order: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AutomationRuleModifyPropertiesActionArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.AutomationRuleModifyPropertiesActionArgs =
        com.pulumi.azurenative.securityinsights.inputs.AutomationRuleModifyPropertiesActionArgs.builder()
            .actionConfiguration(
                actionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .order(order.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleModifyPropertiesActionArgs].
 */
@PulumiTagMarker
public class AutomationRuleModifyPropertiesActionArgsBuilder internal constructor() {
    private var actionConfiguration: Output<IncidentPropertiesActionArgs>? = null

    private var actionType: Output<String>? = null

    private var order: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("vapmnchrjawkgvrv")
    public suspend fun actionConfiguration(`value`: Output<IncidentPropertiesActionArgs>) {
        this.actionConfiguration = value
    }

    /**
     * @param value The type of the automation rule action.
     * Expected value is 'ModifyProperties'.
     */
    @JvmName("sboopyspnprbqxxm")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value
     */
    @JvmName("uimnddmninctcuar")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value
     */
    @JvmName("bhpdtgctvxtgwekp")
    public suspend fun actionConfiguration(`value`: IncidentPropertiesActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bwmdsirpwmqcgoev")
    public suspend
    fun actionConfiguration(argument: suspend IncidentPropertiesActionArgsBuilder.() -> Unit) {
        val toBeMapped = IncidentPropertiesActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actionConfiguration = mapped
    }

    /**
     * @param value The type of the automation rule action.
     * Expected value is 'ModifyProperties'.
     */
    @JvmName("cpbnhhmojyxclpaj")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value
     */
    @JvmName("axalpbpdmcfydccs")
    public suspend fun order(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    internal fun build(): AutomationRuleModifyPropertiesActionArgs =
        AutomationRuleModifyPropertiesActionArgs(
            actionConfiguration = actionConfiguration,
            actionType = actionType ?: throw PulumiNullFieldException("actionType"),
            order = order ?: throw PulumiNullFieldException("order"),
        )
}
