@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AutomationRuleTriggeringLogicArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.TriggersOn
import com.pulumi.azurenative.securityinsights.kotlin.enums.TriggersWhen
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes automation rule triggering logic.
 * @property conditions The conditions to evaluate to determine if the automation rule should be triggered on a given object.
 * @property expirationTimeUtc Determines when the automation rule should automatically expire and be disabled.
 * @property isEnabled Determines whether the automation rule is enabled or disabled.
 * @property triggersOn
 * @property triggersWhen
 */
public data class AutomationRuleTriggeringLogicArgs(
    public val conditions: Output<List<Any>>? = null,
    public val expirationTimeUtc: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
    public val triggersOn: Output<Either<String, TriggersOn>>,
    public val triggersWhen: Output<Either<String, TriggersWhen>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AutomationRuleTriggeringLogicArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.AutomationRuleTriggeringLogicArgs =
        com.pulumi.azurenative.securityinsights.inputs.AutomationRuleTriggeringLogicArgs.builder()
            .conditions(conditions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .expirationTimeUtc(expirationTimeUtc?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .triggersOn(
                triggersOn.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .triggersWhen(
                triggersWhen.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomationRuleTriggeringLogicArgs].
 */
@PulumiTagMarker
public class AutomationRuleTriggeringLogicArgsBuilder internal constructor() {
    private var conditions: Output<List<Any>>? = null

    private var expirationTimeUtc: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var triggersOn: Output<Either<String, TriggersOn>>? = null

    private var triggersWhen: Output<Either<String, TriggersWhen>>? = null

    /**
     * @param value The conditions to evaluate to determine if the automation rule should be triggered on a given object.
     */
    @JvmName("ilsmfggngiympuaj")
    public suspend fun conditions(`value`: Output<List<Any>>) {
        this.conditions = value
    }

    @JvmName("ldbjrlrubbnnkydr")
    public suspend fun conditions(vararg values: Output<Any>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values The conditions to evaluate to determine if the automation rule should be triggered on a given object.
     */
    @JvmName("dduaxntdvolihaar")
    public suspend fun conditions(values: List<Output<Any>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value Determines when the automation rule should automatically expire and be disabled.
     */
    @JvmName("aansvxssvqiguyne")
    public suspend fun expirationTimeUtc(`value`: Output<String>) {
        this.expirationTimeUtc = value
    }

    /**
     * @param value Determines whether the automation rule is enabled or disabled.
     */
    @JvmName("pkwttqggpretropo")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("nweaygovgaptolbs")
    public suspend fun triggersOn(`value`: Output<Either<String, TriggersOn>>) {
        this.triggersOn = value
    }

    /**
     * @param value
     */
    @JvmName("heefmtskevybxrlt")
    public suspend fun triggersWhen(`value`: Output<Either<String, TriggersWhen>>) {
        this.triggersWhen = value
    }

    /**
     * @param value The conditions to evaluate to determine if the automation rule should be triggered on a given object.
     */
    @JvmName("fxghsvprnptagoww")
    public suspend fun conditions(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param values The conditions to evaluate to determine if the automation rule should be triggered on a given object.
     */
    @JvmName("yjvwbqcxfkupdnnu")
    public suspend fun conditions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value Determines when the automation rule should automatically expire and be disabled.
     */
    @JvmName("ccqronqriaqqkjdg")
    public suspend fun expirationTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTimeUtc = mapped
    }

    /**
     * @param value Determines whether the automation rule is enabled or disabled.
     */
    @JvmName("tanpxkvdfmjeuqmu")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("cqcxusqojvgapnrx")
    public suspend fun triggersOn(`value`: Either<String, TriggersOn>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggersOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("ywrurgrmglwqdrcv")
    public fun triggersOn(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggersOn>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggersOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("vmlmmxrysybphbfo")
    public fun triggersOn(`value`: TriggersOn) {
        val toBeMapped = Either.ofRight<String, TriggersOn>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggersOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihiqndytbncnqddn")
    public suspend fun triggersWhen(`value`: Either<String, TriggersWhen>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggersWhen = mapped
    }

    /**
     * @param value
     */
    @JvmName("poaflygghycgoqff")
    public fun triggersWhen(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggersWhen>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggersWhen = mapped
    }

    /**
     * @param value
     */
    @JvmName("bpkqnwsegdivauiu")
    public fun triggersWhen(`value`: TriggersWhen) {
        val toBeMapped = Either.ofRight<String, TriggersWhen>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggersWhen = mapped
    }

    internal fun build(): AutomationRuleTriggeringLogicArgs = AutomationRuleTriggeringLogicArgs(
        conditions = conditions,
        expirationTimeUtc = expirationTimeUtc,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        triggersOn = triggersOn ?: throw PulumiNullFieldException("triggersOn"),
        triggersWhen = triggersWhen ?: throw PulumiNullFieldException("triggersWhen"),
    )
}
