@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectionsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The UiConfig for 'Customizable' connector definition kind.
 * @property templateSpecName Gets or sets the template name. The template includes ARM templates that can be created by the connector, usually it will be the dataConnectors ARM templates.
 * @property templateSpecVersion Gets or sets the template version.
 */
public data class CustomizableConnectionsConfigArgs(
    public val templateSpecName: Output<String>,
    public val templateSpecVersion: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectionsConfigArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectionsConfigArgs =
        com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectionsConfigArgs.builder()
            .templateSpecName(templateSpecName.applyValue({ args0 -> args0 }))
            .templateSpecVersion(templateSpecVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomizableConnectionsConfigArgs].
 */
@PulumiTagMarker
public class CustomizableConnectionsConfigArgsBuilder internal constructor() {
    private var templateSpecName: Output<String>? = null

    private var templateSpecVersion: Output<String>? = null

    /**
     * @param value Gets or sets the template name. The template includes ARM templates that can be created by the connector, usually it will be the dataConnectors ARM templates.
     */
    @JvmName("ltumqfjvsjsloicf")
    public suspend fun templateSpecName(`value`: Output<String>) {
        this.templateSpecName = value
    }

    /**
     * @param value Gets or sets the template version.
     */
    @JvmName("kohkpguhknmpguyq")
    public suspend fun templateSpecVersion(`value`: Output<String>) {
        this.templateSpecVersion = value
    }

    /**
     * @param value Gets or sets the template name. The template includes ARM templates that can be created by the connector, usually it will be the dataConnectors ARM templates.
     */
    @JvmName("nngaghtgalsfigiv")
    public suspend fun templateSpecName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateSpecName = mapped
    }

    /**
     * @param value Gets or sets the template version.
     */
    @JvmName("tinkvrfodwiamhta")
    public suspend fun templateSpecVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateSpecVersion = mapped
    }

    internal fun build(): CustomizableConnectionsConfigArgs = CustomizableConnectionsConfigArgs(
        templateSpecName = templateSpecName ?: throw PulumiNullFieldException("templateSpecName"),
        templateSpecVersion = templateSpecVersion ?: throw PulumiNullFieldException("templateSpecVersion"),
    )
}
