@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectorUiConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The UiConfig for 'Customizable' connector definition kind.
 * @property availability The exposure status of the connector to the customers.
 * @property connectivityCriteria Gets or sets the way the connector checks whether the connector is connected.
 * @property dataTypes Gets or sets the data types to check for last data received.
 * @property descriptionMarkdown Gets or sets the connector description in markdown format.
 * @property graphQueries Gets or sets the graph queries to show the current data volume over time.
 * @property graphQueriesTableName Gets or sets the name of the table the connector will insert the data to.
 * This name can be used in other queries by specifying {{graphQueriesTableName}} placeholder
 *  in Query and LastDataReceivedQuery values.
 * @property id Gets or sets custom connector id. optional field.
 * @property instructionSteps Gets or sets the instruction steps to enable the connector.
 * @property isConnectivityCriteriasMatchSome Gets or sets a value indicating whether to use 'OR'(SOME) or 'AND' between ConnectivityCriteria items.
 * @property logo Gets or sets the connector logo to be used when displaying the connector within Azure Sentinel's connector's gallery.
 * The logo value should be in SVG format.
 * @property permissions The required Permissions for the connector.
 * @property publisher Gets or sets the connector publisher name.
 * @property sampleQueries Gets or sets the sample queries for the connector.
 * @property title Gets or sets the connector blade title.
 */
public data class CustomizableConnectorUiConfigArgs(
    public val availability: Output<ConnectorDefinitionsAvailabilityArgs>? = null,
    public val connectivityCriteria: Output<List<ConnectivityCriterionArgs>>,
    public val dataTypes: Output<List<ConnectorDataTypeArgs>>,
    public val descriptionMarkdown: Output<String>,
    public val graphQueries: Output<List<GraphQueryArgs>>,
    public val graphQueriesTableName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val instructionSteps: Output<List<InstructionStepArgs>>,
    public val isConnectivityCriteriasMatchSome: Output<Boolean>? = null,
    public val logo: Output<String>? = null,
    public val permissions: Output<ConnectorDefinitionsPermissionsArgs>,
    public val publisher: Output<String>,
    public val sampleQueries: Output<List<SampleQueryArgs>>,
    public val title: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectorUiConfigArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectorUiConfigArgs =
        com.pulumi.azurenative.securityinsights.inputs.CustomizableConnectorUiConfigArgs.builder()
            .availability(availability?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectivityCriteria(
                connectivityCriteria.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataTypes(
                dataTypes.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .descriptionMarkdown(descriptionMarkdown.applyValue({ args0 -> args0 }))
            .graphQueries(
                graphQueries.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .graphQueriesTableName(graphQueriesTableName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .instructionSteps(
                instructionSteps.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isConnectivityCriteriasMatchSome(isConnectivityCriteriasMatchSome?.applyValue({ args0 -> args0 }))
            .logo(logo?.applyValue({ args0 -> args0 }))
            .permissions(permissions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisher(publisher.applyValue({ args0 -> args0 }))
            .sampleQueries(
                sampleQueries.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .title(title.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomizableConnectorUiConfigArgs].
 */
@PulumiTagMarker
public class CustomizableConnectorUiConfigArgsBuilder internal constructor() {
    private var availability: Output<ConnectorDefinitionsAvailabilityArgs>? = null

    private var connectivityCriteria: Output<List<ConnectivityCriterionArgs>>? = null

    private var dataTypes: Output<List<ConnectorDataTypeArgs>>? = null

    private var descriptionMarkdown: Output<String>? = null

    private var graphQueries: Output<List<GraphQueryArgs>>? = null

    private var graphQueriesTableName: Output<String>? = null

    private var id: Output<String>? = null

    private var instructionSteps: Output<List<InstructionStepArgs>>? = null

    private var isConnectivityCriteriasMatchSome: Output<Boolean>? = null

    private var logo: Output<String>? = null

    private var permissions: Output<ConnectorDefinitionsPermissionsArgs>? = null

    private var publisher: Output<String>? = null

    private var sampleQueries: Output<List<SampleQueryArgs>>? = null

    private var title: Output<String>? = null

    /**
     * @param value The exposure status of the connector to the customers.
     */
    @JvmName("etyqpuharklkuxsm")
    public suspend fun availability(`value`: Output<ConnectorDefinitionsAvailabilityArgs>) {
        this.availability = value
    }

    /**
     * @param value Gets or sets the way the connector checks whether the connector is connected.
     */
    @JvmName("ucfuijuhdqkrmhok")
    public suspend fun connectivityCriteria(`value`: Output<List<ConnectivityCriterionArgs>>) {
        this.connectivityCriteria = value
    }

    @JvmName("uvftypmcywqqlyfh")
    public suspend fun connectivityCriteria(vararg values: Output<ConnectivityCriterionArgs>) {
        this.connectivityCriteria = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the way the connector checks whether the connector is connected.
     */
    @JvmName("ukxojttuijeohwtm")
    public suspend fun connectivityCriteria(values: List<Output<ConnectivityCriterionArgs>>) {
        this.connectivityCriteria = Output.all(values)
    }

    /**
     * @param value Gets or sets the data types to check for last data received.
     */
    @JvmName("udjqvhrodsjbxkvv")
    public suspend fun dataTypes(`value`: Output<List<ConnectorDataTypeArgs>>) {
        this.dataTypes = value
    }

    @JvmName("wpeapiagawqctukp")
    public suspend fun dataTypes(vararg values: Output<ConnectorDataTypeArgs>) {
        this.dataTypes = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the data types to check for last data received.
     */
    @JvmName("rsshvncymquvngnt")
    public suspend fun dataTypes(values: List<Output<ConnectorDataTypeArgs>>) {
        this.dataTypes = Output.all(values)
    }

    /**
     * @param value Gets or sets the connector description in markdown format.
     */
    @JvmName("jklmitfxeuxrratg")
    public suspend fun descriptionMarkdown(`value`: Output<String>) {
        this.descriptionMarkdown = value
    }

    /**
     * @param value Gets or sets the graph queries to show the current data volume over time.
     */
    @JvmName("jcblokbwyvogdtrx")
    public suspend fun graphQueries(`value`: Output<List<GraphQueryArgs>>) {
        this.graphQueries = value
    }

    @JvmName("orqsfdoupswmbaqd")
    public suspend fun graphQueries(vararg values: Output<GraphQueryArgs>) {
        this.graphQueries = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the graph queries to show the current data volume over time.
     */
    @JvmName("vpsptvjyjcwfhhsy")
    public suspend fun graphQueries(values: List<Output<GraphQueryArgs>>) {
        this.graphQueries = Output.all(values)
    }

    /**
     * @param value Gets or sets the name of the table the connector will insert the data to.
     * This name can be used in other queries by specifying {{graphQueriesTableName}} placeholder
     *  in Query and LastDataReceivedQuery values.
     */
    @JvmName("ogpuhdonppjmabhx")
    public suspend fun graphQueriesTableName(`value`: Output<String>) {
        this.graphQueriesTableName = value
    }

    /**
     * @param value Gets or sets custom connector id. optional field.
     */
    @JvmName("ebvdyepdjoubnkuq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Gets or sets the instruction steps to enable the connector.
     */
    @JvmName("menicuibjfubtkli")
    public suspend fun instructionSteps(`value`: Output<List<InstructionStepArgs>>) {
        this.instructionSteps = value
    }

    @JvmName("uqnnhinstnewgikn")
    public suspend fun instructionSteps(vararg values: Output<InstructionStepArgs>) {
        this.instructionSteps = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the instruction steps to enable the connector.
     */
    @JvmName("pbydtsehvjgxegni")
    public suspend fun instructionSteps(values: List<Output<InstructionStepArgs>>) {
        this.instructionSteps = Output.all(values)
    }

    /**
     * @param value Gets or sets a value indicating whether to use 'OR'(SOME) or 'AND' between ConnectivityCriteria items.
     */
    @JvmName("bnmmykdhqhmpsndv")
    public suspend fun isConnectivityCriteriasMatchSome(`value`: Output<Boolean>) {
        this.isConnectivityCriteriasMatchSome = value
    }

    /**
     * @param value Gets or sets the connector logo to be used when displaying the connector within Azure Sentinel's connector's gallery.
     * The logo value should be in SVG format.
     */
    @JvmName("mfpesvnpcmdansog")
    public suspend fun logo(`value`: Output<String>) {
        this.logo = value
    }

    /**
     * @param value The required Permissions for the connector.
     */
    @JvmName("scavebsbkmidciol")
    public suspend fun permissions(`value`: Output<ConnectorDefinitionsPermissionsArgs>) {
        this.permissions = value
    }

    /**
     * @param value Gets or sets the connector publisher name.
     */
    @JvmName("pegfvmvplslproox")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Gets or sets the sample queries for the connector.
     */
    @JvmName("wsbccwbjhkmrmnqg")
    public suspend fun sampleQueries(`value`: Output<List<SampleQueryArgs>>) {
        this.sampleQueries = value
    }

    @JvmName("wrwqnaascyommawu")
    public suspend fun sampleQueries(vararg values: Output<SampleQueryArgs>) {
        this.sampleQueries = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the sample queries for the connector.
     */
    @JvmName("uwatfbwtgwhircvv")
    public suspend fun sampleQueries(values: List<Output<SampleQueryArgs>>) {
        this.sampleQueries = Output.all(values)
    }

    /**
     * @param value Gets or sets the connector blade title.
     */
    @JvmName("awhdfnkwktowevda")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The exposure status of the connector to the customers.
     */
    @JvmName("gnxrqfdgtrjivjfh")
    public suspend fun availability(`value`: ConnectorDefinitionsAvailabilityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availability = mapped
    }

    /**
     * @param argument The exposure status of the connector to the customers.
     */
    @JvmName("wswpqxsbxvxkweyd")
    public suspend
    fun availability(argument: suspend ConnectorDefinitionsAvailabilityArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorDefinitionsAvailabilityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.availability = mapped
    }

    /**
     * @param value Gets or sets the way the connector checks whether the connector is connected.
     */
    @JvmName("nfnpnclfivhvdlht")
    public suspend fun connectivityCriteria(`value`: List<ConnectivityCriterionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivityCriteria = mapped
    }

    /**
     * @param argument Gets or sets the way the connector checks whether the connector is connected.
     */
    @JvmName("tttnlragaowmjbbh")
    public suspend
    fun connectivityCriteria(argument: List<suspend ConnectivityCriterionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectivityCriterionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectivityCriteria = mapped
    }

    /**
     * @param argument Gets or sets the way the connector checks whether the connector is connected.
     */
    @JvmName("ptbcutynbfrtqlyy")
    public suspend fun connectivityCriteria(
        vararg
        argument: suspend ConnectivityCriterionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectivityCriterionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectivityCriteria = mapped
    }

    /**
     * @param argument Gets or sets the way the connector checks whether the connector is connected.
     */
    @JvmName("nqbvjgrxvghcaixf")
    public suspend
    fun connectivityCriteria(argument: suspend ConnectivityCriterionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnectivityCriterionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connectivityCriteria = mapped
    }

    /**
     * @param values Gets or sets the way the connector checks whether the connector is connected.
     */
    @JvmName("xpphdgwlwshwupwb")
    public suspend fun connectivityCriteria(vararg values: ConnectivityCriterionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivityCriteria = mapped
    }

    /**
     * @param value Gets or sets the data types to check for last data received.
     */
    @JvmName("gnxuuirifvwwgywk")
    public suspend fun dataTypes(`value`: List<ConnectorDataTypeArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param argument Gets or sets the data types to check for last data received.
     */
    @JvmName("xhltnlyuaqxmsdmc")
    public suspend fun dataTypes(argument: List<suspend ConnectorDataTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectorDataTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataTypes = mapped
    }

    /**
     * @param argument Gets or sets the data types to check for last data received.
     */
    @JvmName("hiqmakwwtngojepd")
    public suspend fun dataTypes(vararg argument: suspend ConnectorDataTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectorDataTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataTypes = mapped
    }

    /**
     * @param argument Gets or sets the data types to check for last data received.
     */
    @JvmName("bbgnbocanospafjh")
    public suspend fun dataTypes(argument: suspend ConnectorDataTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnectorDataTypeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataTypes = mapped
    }

    /**
     * @param values Gets or sets the data types to check for last data received.
     */
    @JvmName("opaqegigchqouiyi")
    public suspend fun dataTypes(vararg values: ConnectorDataTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param value Gets or sets the connector description in markdown format.
     */
    @JvmName("wujvtdmwdmnfmjao")
    public suspend fun descriptionMarkdown(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.descriptionMarkdown = mapped
    }

    /**
     * @param value Gets or sets the graph queries to show the current data volume over time.
     */
    @JvmName("vrwqhacbcixptcwv")
    public suspend fun graphQueries(`value`: List<GraphQueryArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.graphQueries = mapped
    }

    /**
     * @param argument Gets or sets the graph queries to show the current data volume over time.
     */
    @JvmName("gakcwfdlghgmrmtk")
    public suspend fun graphQueries(argument: List<suspend GraphQueryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GraphQueryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.graphQueries = mapped
    }

    /**
     * @param argument Gets or sets the graph queries to show the current data volume over time.
     */
    @JvmName("glphjtffcooihkgg")
    public suspend fun graphQueries(vararg argument: suspend GraphQueryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GraphQueryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.graphQueries = mapped
    }

    /**
     * @param argument Gets or sets the graph queries to show the current data volume over time.
     */
    @JvmName("frkkriqqkiyvcuqi")
    public suspend fun graphQueries(argument: suspend GraphQueryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GraphQueryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.graphQueries = mapped
    }

    /**
     * @param values Gets or sets the graph queries to show the current data volume over time.
     */
    @JvmName("jcmhbuhufwgaxrnk")
    public suspend fun graphQueries(vararg values: GraphQueryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.graphQueries = mapped
    }

    /**
     * @param value Gets or sets the name of the table the connector will insert the data to.
     * This name can be used in other queries by specifying {{graphQueriesTableName}} placeholder
     *  in Query and LastDataReceivedQuery values.
     */
    @JvmName("ambrwenngbiugpby")
    public suspend fun graphQueriesTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphQueriesTableName = mapped
    }

    /**
     * @param value Gets or sets custom connector id. optional field.
     */
    @JvmName("lslkyfkihsgvaswr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Gets or sets the instruction steps to enable the connector.
     */
    @JvmName("gtqecgtilhjlvpqr")
    public suspend fun instructionSteps(`value`: List<InstructionStepArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instructionSteps = mapped
    }

    /**
     * @param argument Gets or sets the instruction steps to enable the connector.
     */
    @JvmName("uyguriedhroifuyq")
    public suspend
    fun instructionSteps(argument: List<suspend InstructionStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstructionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instructionSteps = mapped
    }

    /**
     * @param argument Gets or sets the instruction steps to enable the connector.
     */
    @JvmName("dlplqhubayrbfrlr")
    public suspend fun instructionSteps(
        vararg
        argument: suspend InstructionStepArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstructionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instructionSteps = mapped
    }

    /**
     * @param argument Gets or sets the instruction steps to enable the connector.
     */
    @JvmName("dwfbuwrgmywwcqvk")
    public suspend fun instructionSteps(argument: suspend InstructionStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstructionStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.instructionSteps = mapped
    }

    /**
     * @param values Gets or sets the instruction steps to enable the connector.
     */
    @JvmName("dplmojibvoisnabs")
    public suspend fun instructionSteps(vararg values: InstructionStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instructionSteps = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether to use 'OR'(SOME) or 'AND' between ConnectivityCriteria items.
     */
    @JvmName("qmemmhefmnmyeicu")
    public suspend fun isConnectivityCriteriasMatchSome(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isConnectivityCriteriasMatchSome = mapped
    }

    /**
     * @param value Gets or sets the connector logo to be used when displaying the connector within Azure Sentinel's connector's gallery.
     * The logo value should be in SVG format.
     */
    @JvmName("xgjhxkjxgocnsuno")
    public suspend fun logo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logo = mapped
    }

    /**
     * @param value The required Permissions for the connector.
     */
    @JvmName("jyampxuwrtstjsjr")
    public suspend fun permissions(`value`: ConnectorDefinitionsPermissionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument The required Permissions for the connector.
     */
    @JvmName("nwpiowuaycgvavsc")
    public suspend
    fun permissions(argument: suspend ConnectorDefinitionsPermissionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorDefinitionsPermissionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param value Gets or sets the connector publisher name.
     */
    @JvmName("yrgwicnuqsjqbmtu")
    public suspend fun publisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Gets or sets the sample queries for the connector.
     */
    @JvmName("rlovhwbmeoewevuj")
    public suspend fun sampleQueries(`value`: List<SampleQueryArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampleQueries = mapped
    }

    /**
     * @param argument Gets or sets the sample queries for the connector.
     */
    @JvmName("nqdwlpbhxkgblodq")
    public suspend fun sampleQueries(argument: List<suspend SampleQueryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SampleQueryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sampleQueries = mapped
    }

    /**
     * @param argument Gets or sets the sample queries for the connector.
     */
    @JvmName("pjdiemqrrewrbjbt")
    public suspend fun sampleQueries(vararg argument: suspend SampleQueryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SampleQueryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sampleQueries = mapped
    }

    /**
     * @param argument Gets or sets the sample queries for the connector.
     */
    @JvmName("spbphgefmdbqudhk")
    public suspend fun sampleQueries(argument: suspend SampleQueryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SampleQueryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sampleQueries = mapped
    }

    /**
     * @param values Gets or sets the sample queries for the connector.
     */
    @JvmName("oragyyesyuyrynbt")
    public suspend fun sampleQueries(vararg values: SampleQueryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampleQueries = mapped
    }

    /**
     * @param value Gets or sets the connector blade title.
     */
    @JvmName("jxiatyhtupvthbqj")
    public suspend fun title(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): CustomizableConnectorUiConfigArgs = CustomizableConnectorUiConfigArgs(
        availability = availability,
        connectivityCriteria = connectivityCriteria ?: throw
            PulumiNullFieldException("connectivityCriteria"),
        dataTypes = dataTypes ?: throw PulumiNullFieldException("dataTypes"),
        descriptionMarkdown = descriptionMarkdown ?: throw PulumiNullFieldException("descriptionMarkdown"),
        graphQueries = graphQueries ?: throw PulumiNullFieldException("graphQueries"),
        graphQueriesTableName = graphQueriesTableName,
        id = id,
        instructionSteps = instructionSteps ?: throw PulumiNullFieldException("instructionSteps"),
        isConnectivityCriteriasMatchSome = isConnectivityCriteriasMatchSome,
        logo = logo,
        permissions = permissions ?: throw PulumiNullFieldException("permissions"),
        publisher = publisher ?: throw PulumiNullFieldException("publisher"),
        sampleQueries = sampleQueries ?: throw PulumiNullFieldException("sampleQueries"),
        title = title ?: throw PulumiNullFieldException("title"),
    )
}
