@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.EventGroupingSettingsArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.EventGroupingAggregationKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Event grouping settings property bag.
 * @property aggregationKind The event grouping aggregation kinds
 */
public data class EventGroupingSettingsArgs(
    public val aggregationKind: Output<Either<String, EventGroupingAggregationKind>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.EventGroupingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.EventGroupingSettingsArgs =
        com.pulumi.azurenative.securityinsights.inputs.EventGroupingSettingsArgs.builder()
            .aggregationKind(
                aggregationKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventGroupingSettingsArgs].
 */
@PulumiTagMarker
public class EventGroupingSettingsArgsBuilder internal constructor() {
    private var aggregationKind: Output<Either<String, EventGroupingAggregationKind>>? = null

    /**
     * @param value The event grouping aggregation kinds
     */
    @JvmName("arqdcpkyusmeiony")
    public suspend
    fun aggregationKind(`value`: Output<Either<String, EventGroupingAggregationKind>>) {
        this.aggregationKind = value
    }

    /**
     * @param value The event grouping aggregation kinds
     */
    @JvmName("yygykjkeqrlsaqvm")
    public suspend fun aggregationKind(`value`: Either<String, EventGroupingAggregationKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregationKind = mapped
    }

    /**
     * @param value The event grouping aggregation kinds
     */
    @JvmName("ntkhofxqegwbesho")
    public fun aggregationKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventGroupingAggregationKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aggregationKind = mapped
    }

    /**
     * @param value The event grouping aggregation kinds
     */
    @JvmName("eccxdjjcvsdxjmdd")
    public fun aggregationKind(`value`: EventGroupingAggregationKind) {
        val toBeMapped = Either.ofRight<String, EventGroupingAggregationKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aggregationKind = mapped
    }

    internal fun build(): EventGroupingSettingsArgs = EventGroupingSettingsArgs(
        aggregationKind = aggregationKind,
    )
}
