@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetEntityInsightsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property addDefaultExtendedTimeRange Indicates if query time range should be extended with default time range of the query. Default value is false
 * @property endTime The end timeline date, so the results returned are before this date.
 * @property entityId entity ID
 * @property insightQueryIds List of Insights Query Id. If empty, default value is all insights of this entity
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property startTime The start timeline date, so the results returned are after this date.
 * @property workspaceName The name of the workspace.
 */
public data class GetEntityInsightsPlainArgs(
    public val addDefaultExtendedTimeRange: Boolean? = null,
    public val endTime: String,
    public val entityId: String,
    public val insightQueryIds: List<String>? = null,
    public val resourceGroupName: String,
    public val startTime: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetEntityInsightsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetEntityInsightsPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetEntityInsightsPlainArgs.builder()
            .addDefaultExtendedTimeRange(addDefaultExtendedTimeRange?.let({ args0 -> args0 }))
            .endTime(endTime.let({ args0 -> args0 }))
            .entityId(entityId.let({ args0 -> args0 }))
            .insightQueryIds(insightQueryIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .startTime(startTime.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEntityInsightsPlainArgs].
 */
@PulumiTagMarker
public class GetEntityInsightsPlainArgsBuilder internal constructor() {
    private var addDefaultExtendedTimeRange: Boolean? = null

    private var endTime: String? = null

    private var entityId: String? = null

    private var insightQueryIds: List<String>? = null

    private var resourceGroupName: String? = null

    private var startTime: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Indicates if query time range should be extended with default time range of the query. Default value is false
     */
    @JvmName("gvyuomhqwsmonnyd")
    public suspend fun addDefaultExtendedTimeRange(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addDefaultExtendedTimeRange = mapped
    }

    /**
     * @param value The end timeline date, so the results returned are before this date.
     */
    @JvmName("jkpwayxryaxcovsc")
    public suspend fun endTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value entity ID
     */
    @JvmName("qdulhilrfcmhynca")
    public suspend fun entityId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.entityId = mapped
    }

    /**
     * @param value List of Insights Query Id. If empty, default value is all insights of this entity
     */
    @JvmName("rqkacgukbtfnrorr")
    public suspend fun insightQueryIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.insightQueryIds = mapped
    }

    /**
     * @param values List of Insights Query Id. If empty, default value is all insights of this entity
     */
    @JvmName("bwcgviojooxipjsx")
    public suspend fun insightQueryIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.insightQueryIds = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("asfkdejvhbqubxfr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The start timeline date, so the results returned are after this date.
     */
    @JvmName("rwqfckjqyoapains")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.startTime = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pkruoqaiqffpijqv")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetEntityInsightsPlainArgs = GetEntityInsightsPlainArgs(
        addDefaultExtendedTimeRange = addDefaultExtendedTimeRange,
        endTime = endTime ?: throw PulumiNullFieldException("endTime"),
        entityId = entityId ?: throw PulumiNullFieldException("entityId"),
        insightQueryIds = insightQueryIds,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
