@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetIncidentRelationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property incidentId Incident ID
 * @property relationName Relation Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetIncidentRelationPlainArgs(
    public val incidentId: String,
    public val relationName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetIncidentRelationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetIncidentRelationPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetIncidentRelationPlainArgs.builder()
            .incidentId(incidentId.let({ args0 -> args0 }))
            .relationName(relationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIncidentRelationPlainArgs].
 */
@PulumiTagMarker
public class GetIncidentRelationPlainArgsBuilder internal constructor() {
    private var incidentId: String? = null

    private var relationName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Incident ID
     */
    @JvmName("svibsyhsbadwsyvp")
    public suspend fun incidentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.incidentId = mapped
    }

    /**
     * @param value Relation Name
     */
    @JvmName("jrtrvtnjotcqxsgm")
    public suspend fun relationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("agbssuofxekxiioa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gbckevwgeskmttxh")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIncidentRelationPlainArgs = GetIncidentRelationPlainArgs(
        incidentId = incidentId ?: throw PulumiNullFieldException("incidentId"),
        relationName = relationName ?: throw PulumiNullFieldException("relationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
