@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetIncidentTaskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property incidentId Incident ID
 * @property incidentTaskId Incident task ID
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetIncidentTaskPlainArgs(
    public val incidentId: String,
    public val incidentTaskId: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetIncidentTaskPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetIncidentTaskPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetIncidentTaskPlainArgs.builder()
            .incidentId(incidentId.let({ args0 -> args0 }))
            .incidentTaskId(incidentTaskId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIncidentTaskPlainArgs].
 */
@PulumiTagMarker
public class GetIncidentTaskPlainArgsBuilder internal constructor() {
    private var incidentId: String? = null

    private var incidentTaskId: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Incident ID
     */
    @JvmName("nxbfnxeycmhsmaci")
    public suspend fun incidentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.incidentId = mapped
    }

    /**
     * @param value Incident task ID
     */
    @JvmName("npyhedfeqhygbfex")
    public suspend fun incidentTaskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.incidentTaskId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vnbquxnuomeiubmj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iudbbhbnyenuugga")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIncidentTaskPlainArgs = GetIncidentTaskPlainArgs(
        incidentId = incidentId ?: throw PulumiNullFieldException("incidentId"),
        incidentTaskId = incidentTaskId ?: throw PulumiNullFieldException("incidentTaskId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
