@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetSentinelOnboardingStatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sentinelOnboardingStateName The Sentinel onboarding state name. Supports - default
 * @property workspaceName The name of the workspace.
 */
public data class GetSentinelOnboardingStatePlainArgs(
    public val resourceGroupName: String,
    public val sentinelOnboardingStateName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetSentinelOnboardingStatePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetSentinelOnboardingStatePlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetSentinelOnboardingStatePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sentinelOnboardingStateName(sentinelOnboardingStateName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSentinelOnboardingStatePlainArgs].
 */
@PulumiTagMarker
public class GetSentinelOnboardingStatePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sentinelOnboardingStateName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("clcqitbfemdnecft")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Sentinel onboarding state name. Supports - default
     */
    @JvmName("nodqnjfpueulemal")
    public suspend fun sentinelOnboardingStateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sentinelOnboardingStateName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("caypcklbkieqcyws")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSentinelOnboardingStatePlainArgs = GetSentinelOnboardingStatePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sentinelOnboardingStateName = sentinelOnboardingStateName ?: throw
            PulumiNullFieldException("sentinelOnboardingStateName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
