@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceManagerGroupName The name of the workspace manager group
 * @property workspaceName The name of the workspace.
 */
public data class GetWorkspaceManagerGroupPlainArgs(
    public val resourceGroupName: String,
    public val workspaceManagerGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerGroupPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerGroupPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceManagerGroupName(workspaceManagerGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceManagerGroupPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceManagerGroupPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceManagerGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fpmklpjnrdpespce")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace manager group
     */
    @JvmName("uhdoeqlrdpfrtndy")
    public suspend fun workspaceManagerGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceManagerGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kyuxcirlqfddkxno")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspaceManagerGroupPlainArgs = GetWorkspaceManagerGroupPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceManagerGroupName = workspaceManagerGroupName ?: throw
            PulumiNullFieldException("workspaceManagerGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
