@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.HuntOwnerArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.OwnerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a user that the hunt is assigned to
 * @property assignedTo The name of the user the hunt is assigned to.
 * @property email The email of the user the hunt is assigned to.
 * @property objectId The object id of the user the hunt is assigned to.
 * @property ownerType The type of the owner the hunt is assigned to.
 * @property userPrincipalName The user principal name of the user the hunt is assigned to.
 */
public data class HuntOwnerArgs(
    public val assignedTo: Output<String>? = null,
    public val email: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val ownerType: Output<Either<String, OwnerType>>? = null,
    public val userPrincipalName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.HuntOwnerArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.HuntOwnerArgs =
        com.pulumi.azurenative.securityinsights.inputs.HuntOwnerArgs.builder()
            .assignedTo(assignedTo?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .ownerType(
                ownerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .userPrincipalName(userPrincipalName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HuntOwnerArgs].
 */
@PulumiTagMarker
public class HuntOwnerArgsBuilder internal constructor() {
    private var assignedTo: Output<String>? = null

    private var email: Output<String>? = null

    private var objectId: Output<String>? = null

    private var ownerType: Output<Either<String, OwnerType>>? = null

    private var userPrincipalName: Output<String>? = null

    /**
     * @param value The name of the user the hunt is assigned to.
     */
    @JvmName("horfaowgngfiljyl")
    public suspend fun assignedTo(`value`: Output<String>) {
        this.assignedTo = value
    }

    /**
     * @param value The email of the user the hunt is assigned to.
     */
    @JvmName("llscjglqlmskbtuk")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The object id of the user the hunt is assigned to.
     */
    @JvmName("ewqxbigipewyxdsp")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The type of the owner the hunt is assigned to.
     */
    @JvmName("ssopbrbjeysvwjvk")
    public suspend fun ownerType(`value`: Output<Either<String, OwnerType>>) {
        this.ownerType = value
    }

    /**
     * @param value The user principal name of the user the hunt is assigned to.
     */
    @JvmName("okwstcqrfwqlkaji")
    public suspend fun userPrincipalName(`value`: Output<String>) {
        this.userPrincipalName = value
    }

    /**
     * @param value The name of the user the hunt is assigned to.
     */
    @JvmName("sboysqadpvjaigdt")
    public suspend fun assignedTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedTo = mapped
    }

    /**
     * @param value The email of the user the hunt is assigned to.
     */
    @JvmName("bupohdugyjchxvmu")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The object id of the user the hunt is assigned to.
     */
    @JvmName("qnpitqsxnqdrdbue")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The type of the owner the hunt is assigned to.
     */
    @JvmName("sqwlckakahtqiksn")
    public suspend fun ownerType(`value`: Either<String, OwnerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The type of the owner the hunt is assigned to.
     */
    @JvmName("sqhjhvnhxcrtkqov")
    public fun ownerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OwnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The type of the owner the hunt is assigned to.
     */
    @JvmName("qocmcqdmvdcxfyot")
    public fun ownerType(`value`: OwnerType) {
        val toBeMapped = Either.ofRight<String, OwnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The user principal name of the user the hunt is assigned to.
     */
    @JvmName("fuumvjwymlershqh")
    public suspend fun userPrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPrincipalName = mapped
    }

    internal fun build(): HuntOwnerArgs = HuntOwnerArgs(
        assignedTo = assignedTo,
        email = email,
        objectId = objectId,
        ownerType = ownerType,
        userPrincipalName = userPrincipalName,
    )
}
