@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.IncidentLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an incident label
 * @property labelName The name of the label
 */
public data class IncidentLabelArgs(
    public val labelName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.IncidentLabelArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.IncidentLabelArgs =
        com.pulumi.azurenative.securityinsights.inputs.IncidentLabelArgs.builder()
            .labelName(labelName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncidentLabelArgs].
 */
@PulumiTagMarker
public class IncidentLabelArgsBuilder internal constructor() {
    private var labelName: Output<String>? = null

    /**
     * @param value The name of the label
     */
    @JvmName("cxwvwudtppkyjjac")
    public suspend fun labelName(`value`: Output<String>) {
        this.labelName = value
    }

    /**
     * @param value The name of the label
     */
    @JvmName("vnhbrtcxakbokkoy")
    public suspend fun labelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelName = mapped
    }

    internal fun build(): IncidentLabelArgs = IncidentLabelArgs(
        labelName = labelName ?: throw PulumiNullFieldException("labelName"),
    )
}
