@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.InstructionStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Instruction steps to enable the connector.
 * @property description Gets or sets the instruction step description.
 * @property innerSteps Gets or sets the inner instruction steps details.
 * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
 * @property instructions Gets or sets the instruction step details.
 * @property title Gets or sets the instruction step title.
 */
public data class InstructionStepArgs(
    public val description: Output<String>? = null,
    public val innerSteps: Output<List<InstructionStepArgs>>? = null,
    public val instructions: Output<List<InstructionStepDetailsArgs>>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.InstructionStepArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.InstructionStepArgs =
        com.pulumi.azurenative.securityinsights.inputs.InstructionStepArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .innerSteps(
                innerSteps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instructions(
                instructions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstructionStepArgs].
 */
@PulumiTagMarker
public class InstructionStepArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var innerSteps: Output<List<InstructionStepArgs>>? = null

    private var instructions: Output<List<InstructionStepDetailsArgs>>? = null

    private var title: Output<String>? = null

    /**
     * @param value Gets or sets the instruction step description.
     */
    @JvmName("ajgkjyqndgvewtwf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the inner instruction steps details.
     * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
     */
    @JvmName("lbjakrhyahjyfjvt")
    public suspend fun innerSteps(`value`: Output<List<InstructionStepArgs>>) {
        this.innerSteps = value
    }

    @JvmName("qovjyamcjduagqfo")
    public suspend fun innerSteps(vararg values: Output<InstructionStepArgs>) {
        this.innerSteps = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the inner instruction steps details.
     * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
     */
    @JvmName("ttmphxgxfjjnkhpd")
    public suspend fun innerSteps(values: List<Output<InstructionStepArgs>>) {
        this.innerSteps = Output.all(values)
    }

    /**
     * @param value Gets or sets the instruction step details.
     */
    @JvmName("pojjglvuntviwawo")
    public suspend fun instructions(`value`: Output<List<InstructionStepDetailsArgs>>) {
        this.instructions = value
    }

    @JvmName("hqwhqxnnomvovvix")
    public suspend fun instructions(vararg values: Output<InstructionStepDetailsArgs>) {
        this.instructions = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the instruction step details.
     */
    @JvmName("fyryfpjdktkojunj")
    public suspend fun instructions(values: List<Output<InstructionStepDetailsArgs>>) {
        this.instructions = Output.all(values)
    }

    /**
     * @param value Gets or sets the instruction step title.
     */
    @JvmName("vfaqhlseknhfromr")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Gets or sets the instruction step description.
     */
    @JvmName("oingccgqnqxsffyi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the inner instruction steps details.
     * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
     */
    @JvmName("asnmbidxyuujvhwi")
    public suspend fun innerSteps(`value`: List<InstructionStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.innerSteps = mapped
    }

    /**
     * @param argument Gets or sets the inner instruction steps details.
     * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
     */
    @JvmName("sclcqdwupxmknhit")
    public suspend fun innerSteps(argument: List<suspend InstructionStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstructionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.innerSteps = mapped
    }

    /**
     * @param argument Gets or sets the inner instruction steps details.
     * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
     */
    @JvmName("rqufxayosiflyubt")
    public suspend fun innerSteps(vararg argument: suspend InstructionStepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstructionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.innerSteps = mapped
    }

    /**
     * @param argument Gets or sets the inner instruction steps details.
     * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
     */
    @JvmName("ksehnyueydvadqtc")
    public suspend fun innerSteps(argument: suspend InstructionStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstructionStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.innerSteps = mapped
    }

    /**
     * @param values Gets or sets the inner instruction steps details.
     * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
     */
    @JvmName("ourocoskkjlkkobc")
    public suspend fun innerSteps(vararg values: InstructionStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.innerSteps = mapped
    }

    /**
     * @param value Gets or sets the instruction step details.
     */
    @JvmName("vjnummcgvquuhnpu")
    public suspend fun instructions(`value`: List<InstructionStepDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instructions = mapped
    }

    /**
     * @param argument Gets or sets the instruction step details.
     */
    @JvmName("mvgnkjnsgothpnkv")
    public suspend
    fun instructions(argument: List<suspend InstructionStepDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstructionStepDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instructions = mapped
    }

    /**
     * @param argument Gets or sets the instruction step details.
     */
    @JvmName("ctbxhvkfnwvnsouy")
    public suspend fun instructions(
        vararg
        argument: suspend InstructionStepDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstructionStepDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instructions = mapped
    }

    /**
     * @param argument Gets or sets the instruction step details.
     */
    @JvmName("evljsefjjdbpegwc")
    public suspend fun instructions(argument: suspend InstructionStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstructionStepDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.instructions = mapped
    }

    /**
     * @param values Gets or sets the instruction step details.
     */
    @JvmName("chpqiuyqtkeikfqx")
    public suspend fun instructions(vararg values: InstructionStepDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instructions = mapped
    }

    /**
     * @param value Gets or sets the instruction step title.
     */
    @JvmName("npymrywagpaekkfp")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): InstructionStepArgs = InstructionStepArgs(
        description = description,
        innerSteps = innerSteps,
        instructions = instructions,
        title = title,
    )
}
