@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ListWhoisByDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domain The domain name
 * @property enrichmentType Enrichment type
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class ListWhoisByDomainPlainArgs(
    public val domain: String? = null,
    public val enrichmentType: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ListWhoisByDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.ListWhoisByDomainPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.ListWhoisByDomainPlainArgs.builder()
            .domain(domain?.let({ args0 -> args0 }))
            .enrichmentType(enrichmentType.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWhoisByDomainPlainArgs].
 */
@PulumiTagMarker
public class ListWhoisByDomainPlainArgsBuilder internal constructor() {
    private var domain: String? = null

    private var enrichmentType: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The domain name
     */
    @JvmName("amuyenyxlqpbqdpg")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domain = mapped
    }

    /**
     * @param value Enrichment type
     */
    @JvmName("fnrxycndtqwrhylk")
    public suspend fun enrichmentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enrichmentType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hsernyokqbrfutec")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("deknuctqhqwtqvuh")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): ListWhoisByDomainPlainArgs = ListWhoisByDomainPlainArgs(
        domain = domain,
        enrichmentType = enrichmentType ?: throw PulumiNullFieldException("enrichmentType"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
