@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.MCASDataConnectorDataTypesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The available data types for MCAS (Microsoft Cloud App Security) data connector.
 * @property alerts Alerts data type connection.
 * @property discoveryLogs Discovery log data type connection.
 */
public data class MCASDataConnectorDataTypesArgs(
    public val alerts: Output<DataConnectorDataTypeCommonArgs>? = null,
    public val discoveryLogs: Output<DataConnectorDataTypeCommonArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.MCASDataConnectorDataTypesArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.MCASDataConnectorDataTypesArgs =
        com.pulumi.azurenative.securityinsights.inputs.MCASDataConnectorDataTypesArgs.builder()
            .alerts(alerts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .discoveryLogs(discoveryLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MCASDataConnectorDataTypesArgs].
 */
@PulumiTagMarker
public class MCASDataConnectorDataTypesArgsBuilder internal constructor() {
    private var alerts: Output<DataConnectorDataTypeCommonArgs>? = null

    private var discoveryLogs: Output<DataConnectorDataTypeCommonArgs>? = null

    /**
     * @param value Alerts data type connection.
     */
    @JvmName("qbmbdrcvdfguxtqn")
    public suspend fun alerts(`value`: Output<DataConnectorDataTypeCommonArgs>) {
        this.alerts = value
    }

    /**
     * @param value Discovery log data type connection.
     */
    @JvmName("jkhjildereulrmfx")
    public suspend fun discoveryLogs(`value`: Output<DataConnectorDataTypeCommonArgs>) {
        this.discoveryLogs = value
    }

    /**
     * @param value Alerts data type connection.
     */
    @JvmName("cyagdhpvxymxjhyc")
    public suspend fun alerts(`value`: DataConnectorDataTypeCommonArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alerts = mapped
    }

    /**
     * @param argument Alerts data type connection.
     */
    @JvmName("fxmsmthhlctkdkpp")
    public suspend fun alerts(argument: suspend DataConnectorDataTypeCommonArgsBuilder.() -> Unit) {
        val toBeMapped = DataConnectorDataTypeCommonArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alerts = mapped
    }

    /**
     * @param value Discovery log data type connection.
     */
    @JvmName("xgtckptrmyifxtuu")
    public suspend fun discoveryLogs(`value`: DataConnectorDataTypeCommonArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveryLogs = mapped
    }

    /**
     * @param argument Discovery log data type connection.
     */
    @JvmName("dernpuapnwullwbw")
    public suspend
    fun discoveryLogs(argument: suspend DataConnectorDataTypeCommonArgsBuilder.() -> Unit) {
        val toBeMapped = DataConnectorDataTypeCommonArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.discoveryLogs = mapped
    }

    internal fun build(): MCASDataConnectorDataTypesArgs = MCASDataConnectorDataTypesArgs(
        alerts = alerts,
        discoveryLogs = discoveryLogs,
    )
}
