@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.PropertyChangedConditionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an automation rule condition that evaluates a property's value change
 * @property conditionProperties
 * @property conditionType
 * Expected value is 'PropertyChanged'.
 */
public data class PropertyChangedConditionPropertiesArgs(
    public val conditionProperties: Output<AutomationRulePropertyValuesChangedConditionArgs>? = null,
    public val conditionType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.PropertyChangedConditionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.PropertyChangedConditionPropertiesArgs =
        com.pulumi.azurenative.securityinsights.inputs.PropertyChangedConditionPropertiesArgs.builder()
            .conditionProperties(
                conditionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .conditionType(conditionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PropertyChangedConditionPropertiesArgs].
 */
@PulumiTagMarker
public class PropertyChangedConditionPropertiesArgsBuilder internal constructor() {
    private var conditionProperties: Output<AutomationRulePropertyValuesChangedConditionArgs>? = null

    private var conditionType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("oqltlximcdashopf")
    public suspend
    fun conditionProperties(`value`: Output<AutomationRulePropertyValuesChangedConditionArgs>) {
        this.conditionProperties = value
    }

    /**
     * @param value
     * Expected value is 'PropertyChanged'.
     */
    @JvmName("vsxblrnuxxpvtecl")
    public suspend fun conditionType(`value`: Output<String>) {
        this.conditionType = value
    }

    /**
     * @param value
     */
    @JvmName("mtlgxepdfhpspfmq")
    public suspend
    fun conditionProperties(`value`: AutomationRulePropertyValuesChangedConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mwbxutfkaypanpxf")
    public suspend
    fun conditionProperties(argument: suspend AutomationRulePropertyValuesChangedConditionArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRulePropertyValuesChangedConditionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conditionProperties = mapped
    }

    /**
     * @param value
     * Expected value is 'PropertyChanged'.
     */
    @JvmName("djponfkvwybojver")
    public suspend fun conditionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionType = mapped
    }

    internal fun build(): PropertyChangedConditionPropertiesArgs =
        PropertyChangedConditionPropertiesArgs(
            conditionProperties = conditionProperties,
            conditionType = conditionType ?: throw PulumiNullFieldException("conditionType"),
        )
}
