@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The available data types for TI (Threat Intelligence) data connector.
 * @property indicators Data type for indicators connection.
 */
public data class TIDataConnectorDataTypesArgs(
    public val indicators: Output<TIDataConnectorDataTypesIndicatorsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesArgs =
        com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesArgs.builder()
            .indicators(indicators?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TIDataConnectorDataTypesArgs].
 */
@PulumiTagMarker
public class TIDataConnectorDataTypesArgsBuilder internal constructor() {
    private var indicators: Output<TIDataConnectorDataTypesIndicatorsArgs>? = null

    /**
     * @param value Data type for indicators connection.
     */
    @JvmName("ebbhxhyyyuninvoj")
    public suspend fun indicators(`value`: Output<TIDataConnectorDataTypesIndicatorsArgs>) {
        this.indicators = value
    }

    /**
     * @param value Data type for indicators connection.
     */
    @JvmName("vxymexyegswnambi")
    public suspend fun indicators(`value`: TIDataConnectorDataTypesIndicatorsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indicators = mapped
    }

    /**
     * @param argument Data type for indicators connection.
     */
    @JvmName("ascvcopsydctjsjx")
    public suspend
    fun indicators(argument: suspend TIDataConnectorDataTypesIndicatorsArgsBuilder.() -> Unit) {
        val toBeMapped = TIDataConnectorDataTypesIndicatorsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.indicators = mapped
    }

    internal fun build(): TIDataConnectorDataTypesArgs = TIDataConnectorDataTypesArgs(
        indicators = indicators,
    )
}
