@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.WatchlistUserInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User information that made some action
 * @property objectId The object id of the user.
 */
public data class WatchlistUserInfoArgs(
    public val objectId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.WatchlistUserInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.WatchlistUserInfoArgs =
        com.pulumi.azurenative.securityinsights.inputs.WatchlistUserInfoArgs.builder()
            .objectId(objectId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WatchlistUserInfoArgs].
 */
@PulumiTagMarker
public class WatchlistUserInfoArgsBuilder internal constructor() {
    private var objectId: Output<String>? = null

    /**
     * @param value The object id of the user.
     */
    @JvmName("axpdehublcpvgilu")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The object id of the user.
     */
    @JvmName("odcgtohurkukxiih")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    internal fun build(): WatchlistUserInfoArgs = WatchlistUserInfoArgs(
        objectId = objectId,
    )
}
