@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Settings for how to dynamically override alert static details
 * @property alertDescriptionFormat the format containing columns name(s) to override the alert description
 * @property alertDisplayNameFormat the format containing columns name(s) to override the alert name
 * @property alertDynamicProperties List of additional dynamic properties to override
 * @property alertSeverityColumnName the column name to take the alert severity from
 * @property alertTacticsColumnName the column name to take the alert tactics from
 */
public data class AlertDetailsOverrideResponse(
    public val alertDescriptionFormat: String? = null,
    public val alertDisplayNameFormat: String? = null,
    public val alertDynamicProperties: List<AlertPropertyMappingResponse>? = null,
    public val alertSeverityColumnName: String? = null,
    public val alertTacticsColumnName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.AlertDetailsOverrideResponse):
            AlertDetailsOverrideResponse = AlertDetailsOverrideResponse(
            alertDescriptionFormat = javaType.alertDescriptionFormat().map({ args0 -> args0 }).orElse(null),
            alertDisplayNameFormat = javaType.alertDisplayNameFormat().map({ args0 -> args0 }).orElse(null),
            alertDynamicProperties = javaType.alertDynamicProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AlertPropertyMappingResponse.Companion.toKotlin(args0)
                })
            }),
            alertSeverityColumnName = javaType.alertSeverityColumnName().map({ args0 -> args0 }).orElse(null),
            alertTacticsColumnName = javaType.alertTacticsColumnName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
