@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes an automation rule action to modify an object's properties
 * @property actionConfiguration
 * @property actionType The type of the automation rule action.
 * Expected value is 'ModifyProperties'.
 * @property order
 */
public data class AutomationRuleModifyPropertiesActionResponse(
    public val actionConfiguration: IncidentPropertiesActionResponse? = null,
    public val actionType: String,
    public val order: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.AutomationRuleModifyPropertiesActionResponse):
            AutomationRuleModifyPropertiesActionResponse = AutomationRuleModifyPropertiesActionResponse(
            actionConfiguration = javaType.actionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentPropertiesActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            actionType = javaType.actionType(),
            order = javaType.order(),
        )
    }
}
