@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents a file.
 * @property deleteStatus Indicates whether the file was deleted from the storage account.
 * @property fileContentUri A URI with a valid SAS token to allow uploading / downloading the file.
 * @property fileFormat The format of the file
 * @property fileName The name of the file.
 * @property fileSize The size of the file.
 */
public data class FileMetadataResponse(
    public val deleteStatus: String,
    public val fileContentUri: String,
    public val fileFormat: String? = null,
    public val fileName: String? = null,
    public val fileSize: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.FileMetadataResponse):
            FileMetadataResponse = FileMetadataResponse(
            deleteStatus = javaType.deleteStatus(),
            fileContentUri = javaType.fileContentUri(),
            fileFormat = javaType.fileFormat().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            fileSize = javaType.fileSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
