@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents Anomaly Security ML Analytics Settings
 * @property anomalySettingsVersion The anomaly settings version of the Anomaly security ml analytics settings that dictates whether job version gets updated or not.
 * @property anomalyVersion The anomaly version of the AnomalySecurityMLAnalyticsSettings.
 * @property customizableObservations The customizable observations of the AnomalySecurityMLAnalyticsSettings.
 * @property description The description of the SecurityMLAnalyticsSettings.
 * @property displayName The display name for settings created by this SecurityMLAnalyticsSettings.
 * @property enabled Determines whether this settings is enabled or disabled.
 * @property etag Etag of the azure resource
 * @property frequency The frequency that this SecurityMLAnalyticsSettings will be run.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isDefaultSettings Determines whether this anomaly security ml analytics settings is a default settings
 * @property kind The kind of security ML analytics settings
 * Expected value is 'Anomaly'.
 * @property lastModifiedUtc The last time that this SecurityMLAnalyticsSettings has been modified.
 * @property name The name of the resource
 * @property requiredDataConnectors The required data sources for this SecurityMLAnalyticsSettings
 * @property settingsDefinitionId The anomaly settings definition Id
 * @property settingsStatus The anomaly SecurityMLAnalyticsSettings status
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tactics The tactics of the SecurityMLAnalyticsSettings
 * @property techniques The techniques of the SecurityMLAnalyticsSettings
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAnomalySecurityMLAnalyticsSettingsResult(
    public val anomalySettingsVersion: Int? = null,
    public val anomalyVersion: String,
    public val customizableObservations: Any? = null,
    public val description: String? = null,
    public val displayName: String,
    public val enabled: Boolean,
    public val etag: String? = null,
    public val frequency: String,
    public val id: String,
    public val isDefaultSettings: Boolean,
    public val kind: String,
    public val lastModifiedUtc: String,
    public val name: String,
    public val requiredDataConnectors: List<SecurityMLAnalyticsSettingsDataSourceResponse>? = null,
    public val settingsDefinitionId: String? = null,
    public val settingsStatus: String,
    public val systemData: SystemDataResponse,
    public val tactics: List<String>? = null,
    public val techniques: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetAnomalySecurityMLAnalyticsSettingsResult):
            GetAnomalySecurityMLAnalyticsSettingsResult = GetAnomalySecurityMLAnalyticsSettingsResult(
            anomalySettingsVersion = javaType.anomalySettingsVersion().map({ args0 -> args0 }).orElse(null),
            anomalyVersion = javaType.anomalyVersion(),
            customizableObservations = javaType.customizableObservations().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            enabled = javaType.enabled(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            frequency = javaType.frequency(),
            id = javaType.id(),
            isDefaultSettings = javaType.isDefaultSettings(),
            kind = javaType.kind(),
            lastModifiedUtc = javaType.lastModifiedUtc(),
            name = javaType.name(),
            requiredDataConnectors = javaType.requiredDataConnectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.SecurityMLAnalyticsSettingsDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            settingsDefinitionId = javaType.settingsDefinitionId().map({ args0 -> args0 }).orElse(null),
            settingsStatus = javaType.settingsStatus(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tactics = javaType.tactics().map({ args0 -> args0 }),
            techniques = javaType.techniques().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
