@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a relation between two resources
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property relatedResourceId The resource ID of the related resource
 * @property relatedResourceKind The resource kind of the related resource
 * @property relatedResourceName The name of the related resource
 * @property relatedResourceType The resource type of the related resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIncidentRelationResult(
    public val etag: String? = null,
    public val id: String,
    public val name: String,
    public val relatedResourceId: String,
    public val relatedResourceKind: String,
    public val relatedResourceName: String,
    public val relatedResourceType: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetIncidentRelationResult):
            GetIncidentRelationResult = GetIncidentRelationResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            relatedResourceId = javaType.relatedResourceId(),
            relatedResourceKind = javaType.relatedResourceKind(),
            relatedResourceName = javaType.relatedResourceName(),
            relatedResourceType = javaType.relatedResourceType(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
