@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdBy Information on the client (user or application) that made some action
 * @property createdTimeUtc The time the task was created
 * @property description The description of the task
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModifiedBy Information on the client (user or application) that made some action
 * @property lastModifiedTimeUtc The last time the task was updated
 * @property name The name of the resource
 * @property status
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property title The title of the task
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIncidentTaskResult(
    public val createdBy: ClientInfoResponse? = null,
    public val createdTimeUtc: String,
    public val description: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val lastModifiedBy: ClientInfoResponse? = null,
    public val lastModifiedTimeUtc: String,
    public val name: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val title: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetIncidentTaskResult):
            GetIncidentTaskResult = GetIncidentTaskResult(
            createdBy = javaType.createdBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdTimeUtc = javaType.createdTimeUtc(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedBy = javaType.lastModifiedBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedTimeUtc = javaType.lastModifiedTimeUtc(),
            name = javaType.name(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            title = javaType.title(),
            type = javaType.type(),
        )
    }
}
