@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Get Insights result metadata.
 * @property errors information about the failed queries
 * @property totalCount the total items found for the insights request
 */
public data class GetInsightsResultsMetadataResponse(
    public val errors: List<GetInsightsErrorKindResponse>? = null,
    public val totalCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetInsightsResultsMetadataResponse):
            GetInsightsResultsMetadataResponse = GetInsightsResultsMetadataResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.GetInsightsErrorKindResponse.Companion.toKotlin(args0)
                })
            }),
            totalCount = javaType.totalCount(),
        )
    }
}
