@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Grouping configuration property bag.
 * @property enabled Grouping enabled
 * @property groupByAlertDetails A list of alert details to group by (when matchingMethod is Selected)
 * @property groupByCustomDetails A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
 * @property groupByEntities A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
 * @property lookbackDuration Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
 * @property matchingMethod Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
 * @property reopenClosedIncident Re-open closed matching incidents
 */
public data class GroupingConfigurationResponse(
    public val enabled: Boolean,
    public val groupByAlertDetails: List<String>? = null,
    public val groupByCustomDetails: List<String>? = null,
    public val groupByEntities: List<String>? = null,
    public val lookbackDuration: String,
    public val matchingMethod: String,
    public val reopenClosedIncident: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GroupingConfigurationResponse):
            GroupingConfigurationResponse = GroupingConfigurationResponse(
            enabled = javaType.enabled(),
            groupByAlertDetails = javaType.groupByAlertDetails().map({ args0 -> args0 }),
            groupByCustomDetails = javaType.groupByCustomDetails().map({ args0 -> args0 }),
            groupByEntities = javaType.groupByEntities().map({ args0 -> args0 }),
            lookbackDuration = javaType.lookbackDuration(),
            matchingMethod = javaType.matchingMethod(),
            reopenClosedIncident = javaType.reopenClosedIncident(),
        )
    }
}
