@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Whois information for a given domain and associated metadata
 * @property created The timestamp at which this record was created
 * @property domain The domain for this whois record
 * @property expires The timestamp at which this record will expire
 * @property parsedWhois The whois record for a given domain
 * @property server The hostname of this registrar's whois server
 * @property updated The timestamp at which this record was last updated
 */
public data class ListWhoisByDomainResult(
    public val created: String? = null,
    public val domain: String? = null,
    public val expires: String? = null,
    public val parsedWhois: EnrichmentDomainWhoisDetailsResponse? = null,
    public val server: String? = null,
    public val updated: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ListWhoisByDomainResult):
            ListWhoisByDomainResult = ListWhoisByDomainResult(
            created = javaType.created().map({ args0 -> args0 }).orElse(null),
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            expires = javaType.expires().map({ args0 -> args0 }).orElse(null),
            parsedWhois = javaType.parsedWhois().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EnrichmentDomainWhoisDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            updated = javaType.updated().map({ args0 -> args0 }).orElse(null),
        )
    }
}
