@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
 * @property contentId Id of the content item we depend on
 * @property criteria This is the list of dependencies we must fulfill, according to the AND/OR operator
 * @property kind Type of the content item we depend on
 * @property name Name of the content item
 * @property operator Operator used for list of dependencies in criteria array.
 * @property version Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
 */
public data class MetadataDependenciesResponse(
    public val contentId: String? = null,
    public val criteria: List<MetadataDependenciesResponse>? = null,
    public val kind: String? = null,
    public val name: String? = null,
    public val `operator`: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.MetadataDependenciesResponse):
            MetadataDependenciesResponse = MetadataDependenciesResponse(
            contentId = javaType.contentId().map({ args0 -> args0 }).orElse(null),
            criteria = javaType.criteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse.Companion.toKotlin(args0)
                })
            }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
